package me.snowdrop.istio.api.networking.v1alpha3;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class HTTPSettingsFluentImpl<A extends HTTPSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPSettingsFluent<A>{

    private Integer http1MaxPendingRequests;
    private Integer http2MaxRequests;
    private DurationBuilder idleTimeout;
    private Integer maxRequestsPerConnection;
    private Integer maxRetries;

    public HTTPSettingsFluentImpl(){
    }
    public HTTPSettingsFluentImpl(HTTPSettings instance){
            this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
            this.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
            this.withIdleTimeout(instance.getIdleTimeout()); 
            this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
            this.withMaxRetries(instance.getMaxRetries()); 
    }

    public Integer getHttp1MaxPendingRequests(){
            return this.http1MaxPendingRequests;
    }

    public A withHttp1MaxPendingRequests(Integer http1MaxPendingRequests){
            this.http1MaxPendingRequests=http1MaxPendingRequests; return (A) this;
    }

    public Boolean hasHttp1MaxPendingRequests(){
            return this.http1MaxPendingRequests != null;
    }

    public Integer getHttp2MaxRequests(){
            return this.http2MaxRequests;
    }

    public A withHttp2MaxRequests(Integer http2MaxRequests){
            this.http2MaxRequests=http2MaxRequests; return (A) this;
    }

    public Boolean hasHttp2MaxRequests(){
            return this.http2MaxRequests != null;
    }

    
/**
 * This method has been deprecated, please use method buildIdleTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getIdleTimeout(){
            return this.idleTimeout!=null?this.idleTimeout.build():null;
    }

    public Duration buildIdleTimeout(){
            return this.idleTimeout!=null?this.idleTimeout.build():null;
    }

    public A withIdleTimeout(Duration idleTimeout){
            _visitables.get("idleTimeout").remove(this.idleTimeout);
            if (idleTimeout!=null){ this.idleTimeout= new DurationBuilder(idleTimeout); _visitables.get("idleTimeout").add(this.idleTimeout);} return (A) this;
    }

    public Boolean hasIdleTimeout(){
            return this.idleTimeout != null;
    }

    public A withNewIdleTimeout(Integer nanos,Long seconds){
            return (A)withIdleTimeout(new Duration(nanos, seconds));
    }

    public HTTPSettingsFluent.IdleTimeoutNested<A> withNewIdleTimeout(){
            return new IdleTimeoutNestedImpl();
    }

    public HTTPSettingsFluent.IdleTimeoutNested<A> withNewIdleTimeoutLike(Duration item){
            return new IdleTimeoutNestedImpl(item);
    }

    public HTTPSettingsFluent.IdleTimeoutNested<A> editIdleTimeout(){
            return withNewIdleTimeoutLike(getIdleTimeout());
    }

    public HTTPSettingsFluent.IdleTimeoutNested<A> editOrNewIdleTimeout(){
            return withNewIdleTimeoutLike(getIdleTimeout() != null ? getIdleTimeout(): new DurationBuilder().build());
    }

    public HTTPSettingsFluent.IdleTimeoutNested<A> editOrNewIdleTimeoutLike(Duration item){
            return withNewIdleTimeoutLike(getIdleTimeout() != null ? getIdleTimeout(): item);
    }

    public Integer getMaxRequestsPerConnection(){
            return this.maxRequestsPerConnection;
    }

    public A withMaxRequestsPerConnection(Integer maxRequestsPerConnection){
            this.maxRequestsPerConnection=maxRequestsPerConnection; return (A) this;
    }

    public Boolean hasMaxRequestsPerConnection(){
            return this.maxRequestsPerConnection != null;
    }

    public Integer getMaxRetries(){
            return this.maxRetries;
    }

    public A withMaxRetries(Integer maxRetries){
            this.maxRetries=maxRetries; return (A) this;
    }

    public Boolean hasMaxRetries(){
            return this.maxRetries != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HTTPSettingsFluentImpl that = (HTTPSettingsFluentImpl) o;
            if (http1MaxPendingRequests != null ? !http1MaxPendingRequests.equals(that.http1MaxPendingRequests) :that.http1MaxPendingRequests != null) return false;
            if (http2MaxRequests != null ? !http2MaxRequests.equals(that.http2MaxRequests) :that.http2MaxRequests != null) return false;
            if (idleTimeout != null ? !idleTimeout.equals(that.idleTimeout) :that.idleTimeout != null) return false;
            if (maxRequestsPerConnection != null ? !maxRequestsPerConnection.equals(that.maxRequestsPerConnection) :that.maxRequestsPerConnection != null) return false;
            if (maxRetries != null ? !maxRetries.equals(that.maxRetries) :that.maxRetries != null) return false;
            return true;
    }


    public class IdleTimeoutNestedImpl<N> extends DurationFluentImpl<HTTPSettingsFluent.IdleTimeoutNested<N>> implements HTTPSettingsFluent.IdleTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            IdleTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            IdleTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPSettingsFluentImpl.this.withIdleTimeout(builder.build());
    }
    public N endIdleTimeout(){
            return and();
    }

}


}
