package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HeaderOperationsBuilder extends HeaderOperationsFluentImpl<HeaderOperationsBuilder> implements VisitableBuilder<HeaderOperations,HeaderOperationsBuilder>{

    HeaderOperationsFluent<?> fluent;
    Boolean validationEnabled;

    public HeaderOperationsBuilder(){
            this(true);
    }
    public HeaderOperationsBuilder(Boolean validationEnabled){
            this(new HeaderOperations(), validationEnabled);
    }
    public HeaderOperationsBuilder(HeaderOperationsFluent<?> fluent){
            this(fluent, true);
    }
    public HeaderOperationsBuilder(HeaderOperationsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HeaderOperations(), validationEnabled);
    }
    public HeaderOperationsBuilder(HeaderOperationsFluent<?> fluent,HeaderOperations instance){
            this(fluent, instance, true);
    }
    public HeaderOperationsBuilder(HeaderOperationsFluent<?> fluent,HeaderOperations instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAdd(instance.getAdd()); 
            fluent.withRemove(instance.getRemove()); 
            fluent.withSet(instance.getSet()); 
            this.validationEnabled = validationEnabled; 
    }
    public HeaderOperationsBuilder(HeaderOperations instance){
            this(instance,true);
    }
    public HeaderOperationsBuilder(HeaderOperations instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAdd(instance.getAdd()); 
            this.withRemove(instance.getRemove()); 
            this.withSet(instance.getSet()); 
            this.validationEnabled = validationEnabled; 
    }

    public HeaderOperations build(){
            HeaderOperations buildable = new HeaderOperations(fluent.getAdd(),fluent.getRemove(),fluent.getSet());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HeaderOperationsBuilder that = (HeaderOperationsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
