
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "http2Error"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Http2ErrorErrorType implements Serializable, ErrorType
{

    /**
     * 
     * 
     */
    @JsonProperty("http2Error")
    @JsonPropertyDescription("")
    private String http2Error;
    private final static long serialVersionUID = 9121888525316892016L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Http2ErrorErrorType() {
    }

    /**
     * 
     * @param http2Error
     */
    public Http2ErrorErrorType(String http2Error) {
        super();
        this.http2Error = http2Error;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http2Error")
    public String getHttp2Error() {
        return http2Error;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http2Error")
    public void setHttp2Error(String http2Error) {
        this.http2Error = http2Error;
    }

}
