package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HttpCookieHashKeyBuilder extends HttpCookieHashKeyFluentImpl<HttpCookieHashKeyBuilder> implements VisitableBuilder<HttpCookieHashKey,HttpCookieHashKeyBuilder>{

    HttpCookieHashKeyFluent<?> fluent;
    Boolean validationEnabled;

    public HttpCookieHashKeyBuilder(){
            this(true);
    }
    public HttpCookieHashKeyBuilder(Boolean validationEnabled){
            this(new HttpCookieHashKey(), validationEnabled);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent){
            this(fluent, true);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HttpCookieHashKey(), validationEnabled);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent,HttpCookieHashKey instance){
            this(fluent, instance, true);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKeyFluent<?> fluent,HttpCookieHashKey instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttpCookie(instance.getHttpCookie()); 
            this.validationEnabled = validationEnabled; 
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKey instance){
            this(instance,true);
    }
    public HttpCookieHashKeyBuilder(HttpCookieHashKey instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttpCookie(instance.getHttpCookie()); 
            this.validationEnabled = validationEnabled; 
    }

    public HttpCookieHashKey build(){
            HttpCookieHashKey buildable = new HttpCookieHashKey(fluent.getHttpCookie());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HttpCookieHashKeyBuilder that = (HttpCookieHashKeyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
