
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.ConsistentHashLB.HashKey;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "httpHeaderName"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HttpHeaderNameHashKey implements Serializable, HashKey
{

    /**
     * 
     * 
     */
    @JsonProperty("httpHeaderName")
    @JsonPropertyDescription("")
    private String httpHeaderName;
    private final static long serialVersionUID = -2177550405609946157L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HttpHeaderNameHashKey() {
    }

    /**
     * 
     * @param httpHeaderName
     */
    public HttpHeaderNameHashKey(String httpHeaderName) {
        super();
        this.httpHeaderName = httpHeaderName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpHeaderName")
    public String getHttpHeaderName() {
        return httpHeaderName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpHeaderName")
    public void setHttpHeaderName(String httpHeaderName) {
        this.httpHeaderName = httpHeaderName;
    }

}
