package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HttpStatusErrorTypeBuilder extends HttpStatusErrorTypeFluentImpl<HttpStatusErrorTypeBuilder> implements VisitableBuilder<HttpStatusErrorType,HttpStatusErrorTypeBuilder>{

    HttpStatusErrorTypeFluent<?> fluent;
    Boolean validationEnabled;

    public HttpStatusErrorTypeBuilder(){
            this(true);
    }
    public HttpStatusErrorTypeBuilder(Boolean validationEnabled){
            this(new HttpStatusErrorType(), validationEnabled);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent){
            this(fluent, true);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HttpStatusErrorType(), validationEnabled);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent,HttpStatusErrorType instance){
            this(fluent, instance, true);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent,HttpStatusErrorType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttpStatus(instance.getHttpStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorType instance){
            this(instance,true);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttpStatus(instance.getHttpStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public HttpStatusErrorType build(){
            HttpStatusErrorType buildable = new HttpStatusErrorType(fluent.getHttpStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HttpStatusErrorTypeBuilder that = (HttpStatusErrorTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
