package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InsertPositionBuilder extends InsertPositionFluentImpl<InsertPositionBuilder> implements VisitableBuilder<InsertPosition,InsertPositionBuilder>{

    InsertPositionFluent<?> fluent;
    Boolean validationEnabled;

    public InsertPositionBuilder(){
            this(true);
    }
    public InsertPositionBuilder(Boolean validationEnabled){
            this(new InsertPosition(), validationEnabled);
    }
    public InsertPositionBuilder(InsertPositionFluent<?> fluent){
            this(fluent, true);
    }
    public InsertPositionBuilder(InsertPositionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new InsertPosition(), validationEnabled);
    }
    public InsertPositionBuilder(InsertPositionFluent<?> fluent,InsertPosition instance){
            this(fluent, instance, true);
    }
    public InsertPositionBuilder(InsertPositionFluent<?> fluent,InsertPosition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIndex(instance.getIndex()); 
            fluent.withRelativeTo(instance.getRelativeTo()); 
            this.validationEnabled = validationEnabled; 
    }
    public InsertPositionBuilder(InsertPosition instance){
            this(instance,true);
    }
    public InsertPositionBuilder(InsertPosition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIndex(instance.getIndex()); 
            this.withRelativeTo(instance.getRelativeTo()); 
            this.validationEnabled = validationEnabled; 
    }

    public InsertPosition build(){
            InsertPosition buildable = new InsertPosition(fluent.getIndex(),fluent.getRelativeTo());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InsertPositionBuilder that = (InsertPositionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
