
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "bind",
    "captureMode",
    "hosts",
    "port"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class IstioEgressListener implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("bind")
    @JsonPropertyDescription("")
    private String bind;
    @JsonProperty("captureMode")
    private CaptureMode captureMode;
    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    private List<String> hosts = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Port port;
    private final static long serialVersionUID = -5576408134376030132L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public IstioEgressListener() {
    }

    /**
     * 
     * @param bind
     * @param port
     * @param hosts
     * @param captureMode
     */
    public IstioEgressListener(String bind, CaptureMode captureMode, List<String> hosts, Port port) {
        super();
        this.bind = bind;
        this.captureMode = captureMode;
        this.hosts = hosts;
        this.port = port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bind")
    public String getBind() {
        return bind;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bind")
    public void setBind(String bind) {
        this.bind = bind;
    }

    @JsonProperty("captureMode")
    public CaptureMode getCaptureMode() {
        return captureMode;
    }

    @JsonProperty("captureMode")
    public void setCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public Port getPort() {
        return port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public void setPort(Port port) {
        this.port = port;
    }

}
