
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "bind",
    "captureMode",
    "defaultEndpoint",
    "port"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class IstioIngressListener implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("bind")
    @JsonPropertyDescription("")
    private String bind;
    @JsonProperty("captureMode")
    private CaptureMode captureMode;
    /**
     * 
     * 
     */
    @JsonProperty("defaultEndpoint")
    @JsonPropertyDescription("")
    private String defaultEndpoint;
    /**
     * 
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Port port;
    private final static long serialVersionUID = -5595314722989744246L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public IstioIngressListener() {
    }

    /**
     * 
     * @param bind
     * @param port
     * @param defaultEndpoint
     * @param captureMode
     */
    public IstioIngressListener(String bind, CaptureMode captureMode, String defaultEndpoint, Port port) {
        super();
        this.bind = bind;
        this.captureMode = captureMode;
        this.defaultEndpoint = defaultEndpoint;
        this.port = port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bind")
    public String getBind() {
        return bind;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bind")
    public void setBind(String bind) {
        this.bind = bind;
    }

    @JsonProperty("captureMode")
    public CaptureMode getCaptureMode() {
        return captureMode;
    }

    @JsonProperty("captureMode")
    public void setCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultEndpoint")
    public String getDefaultEndpoint() {
        return defaultEndpoint;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultEndpoint")
    public void setDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public Port getPort() {
        return port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public void setPort(Port port) {
        this.port = port;
    }

}
