
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "lbPolicy"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class LoadBalancerSettings implements Serializable
{

    @JsonProperty("lbPolicy")
    @JsonUnwrapped
    private me.snowdrop.istio.api.networking.v1alpha3.LoadBalancerSettings.LbPolicy lbPolicy;
    private final static long serialVersionUID = -6442843933424296411L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LoadBalancerSettings() {
    }

    /**
     * 
     * @param lbPolicy
     */
    public LoadBalancerSettings(me.snowdrop.istio.api.networking.v1alpha3.LoadBalancerSettings.LbPolicy lbPolicy) {
        super();
        this.lbPolicy = lbPolicy;
    }

    @JsonProperty("lbPolicy")
    public me.snowdrop.istio.api.networking.v1alpha3.LoadBalancerSettings.LbPolicy getLbPolicy() {
        return lbPolicy;
    }

    @JsonProperty("lbPolicy")
    public void setLbPolicy(me.snowdrop.istio.api.networking.v1alpha3.LoadBalancerSettings.LbPolicy lbPolicy) {
        this.lbPolicy = lbPolicy;
    }

    public interface LbPolicy extends Serializable
    {


    }

}
