
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "baseEjectionTime",
    "consecutiveErrors",
    "interval",
    "maxEjectionPercent",
    "minHealthPercent"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class OutlierDetection implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("baseEjectionTime")
    @JsonPropertyDescription("")
    private Duration baseEjectionTime;
    /**
     * 
     * 
     */
    @JsonProperty("consecutiveErrors")
    @JsonPropertyDescription("")
    private Integer consecutiveErrors;
    /**
     * 
     * 
     */
    @JsonProperty("interval")
    @JsonPropertyDescription("")
    private Duration interval;
    /**
     * 
     * 
     */
    @JsonProperty("maxEjectionPercent")
    @JsonPropertyDescription("")
    private Integer maxEjectionPercent;
    /**
     * 
     * 
     */
    @JsonProperty("minHealthPercent")
    @JsonPropertyDescription("")
    private Integer minHealthPercent;
    private final static long serialVersionUID = 452412362968063242L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OutlierDetection() {
    }

    /**
     * 
     * @param minHealthPercent
     * @param baseEjectionTime
     * @param consecutiveErrors
     * @param interval
     * @param maxEjectionPercent
     */
    public OutlierDetection(Duration baseEjectionTime, Integer consecutiveErrors, Duration interval, Integer maxEjectionPercent, Integer minHealthPercent) {
        super();
        this.baseEjectionTime = baseEjectionTime;
        this.consecutiveErrors = consecutiveErrors;
        this.interval = interval;
        this.maxEjectionPercent = maxEjectionPercent;
        this.minHealthPercent = minHealthPercent;
    }

    /**
     * 
     * 
     */
    @JsonProperty("baseEjectionTime")
    public Duration getBaseEjectionTime() {
        return baseEjectionTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("baseEjectionTime")
    public void setBaseEjectionTime(Duration baseEjectionTime) {
        this.baseEjectionTime = baseEjectionTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("consecutiveErrors")
    public Integer getConsecutiveErrors() {
        return consecutiveErrors;
    }

    /**
     * 
     * 
     */
    @JsonProperty("consecutiveErrors")
    public void setConsecutiveErrors(Integer consecutiveErrors) {
        this.consecutiveErrors = consecutiveErrors;
    }

    /**
     * 
     * 
     */
    @JsonProperty("interval")
    public Duration getInterval() {
        return interval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("interval")
    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxEjectionPercent")
    public Integer getMaxEjectionPercent() {
        return maxEjectionPercent;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxEjectionPercent")
    public void setMaxEjectionPercent(Integer maxEjectionPercent) {
        this.maxEjectionPercent = maxEjectionPercent;
    }

    /**
     * 
     * 
     */
    @JsonProperty("minHealthPercent")
    public Integer getMinHealthPercent() {
        return minHealthPercent;
    }

    /**
     * 
     * 
     */
    @JsonProperty("minHealthPercent")
    public void setMinHealthPercent(Integer minHealthPercent) {
        this.minHealthPercent = minHealthPercent;
    }

}
