
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "destination",
    "weight"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RouteDestination implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("destination")
    @JsonPropertyDescription("")
    private Destination destination;
    /**
     * 
     * 
     */
    @JsonProperty("weight")
    @JsonPropertyDescription("")
    private Integer weight;
    private final static long serialVersionUID = 6161766538316227623L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RouteDestination() {
    }

    /**
     * 
     * @param destination
     * @param weight
     */
    public RouteDestination(Destination destination, Integer weight) {
        super();
        this.destination = destination;
        this.weight = weight;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destination")
    public Destination getDestination() {
        return destination;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destination")
    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    /**
     * 
     * 
     */
    @JsonProperty("weight")
    public Integer getWeight() {
        return weight;
    }

    /**
     * 
     * 
     */
    @JsonProperty("weight")
    public void setWeight(Integer weight) {
        this.weight = weight;
    }

}
