package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteDestinationBuilder extends RouteDestinationFluentImpl<RouteDestinationBuilder> implements VisitableBuilder<RouteDestination,RouteDestinationBuilder>{

    RouteDestinationFluent<?> fluent;
    Boolean validationEnabled;

    public RouteDestinationBuilder(){
            this(true);
    }
    public RouteDestinationBuilder(Boolean validationEnabled){
            this(new RouteDestination(), validationEnabled);
    }
    public RouteDestinationBuilder(RouteDestinationFluent<?> fluent){
            this(fluent, true);
    }
    public RouteDestinationBuilder(RouteDestinationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteDestination(), validationEnabled);
    }
    public RouteDestinationBuilder(RouteDestinationFluent<?> fluent,RouteDestination instance){
            this(fluent, instance, true);
    }
    public RouteDestinationBuilder(RouteDestinationFluent<?> fluent,RouteDestination instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDestination(instance.getDestination()); 
            fluent.withWeight(instance.getWeight()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteDestinationBuilder(RouteDestination instance){
            this(instance,true);
    }
    public RouteDestinationBuilder(RouteDestination instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDestination(instance.getDestination()); 
            this.withWeight(instance.getWeight()); 
            this.validationEnabled = validationEnabled; 
    }

    public RouteDestination build(){
            RouteDestination buildable = new RouteDestination(fluent.getDestination(),fluent.getWeight());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteDestinationBuilder that = (RouteDestinationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
