
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "addresses",
    "endpoints",
    "exportTo",
    "hosts",
    "location",
    "ports",
    "resolution",
    "subjectAltNames"
})
@IstioKind(name = "ServiceEntry", plural = "serviceentries")
@IstioApiVersion("networking.istio.io/v1alpha3")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class ServiceEntrySpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("addresses")
    @JsonPropertyDescription("")
    private List<String> addresses = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("endpoints")
    @JsonPropertyDescription("")
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    /**
     * 
     * 
     */
    @JsonProperty("exportTo")
    @JsonPropertyDescription("")
    private List<String> exportTo = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    private List<String> hosts = new ArrayList<String>();
    @JsonProperty("location")
    private ServiceEntryLocation location;
    /**
     * 
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    private List<Port> ports = new ArrayList<Port>();
    @JsonProperty("resolution")
    private ServiceEntryResolution resolution;
    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    @JsonPropertyDescription("")
    private List<String> subjectAltNames = new ArrayList<String>();
    private final static long serialVersionUID = -3280203512451769201L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceEntrySpec() {
    }

    /**
     * 
     * @param addresses
     * @param endpoints
     * @param hosts
     * @param location
     * @param subjectAltNames
     * @param exportTo
     * @param ports
     * @param resolution
     */
    public ServiceEntrySpec(List<String> addresses, List<Endpoint> endpoints, List<String> exportTo, List<String> hosts, ServiceEntryLocation location, List<Port> ports, ServiceEntryResolution resolution, List<String> subjectAltNames) {
        super();
        this.addresses = addresses;
        this.endpoints = endpoints;
        this.exportTo = exportTo;
        this.hosts = hosts;
        this.location = location;
        this.ports = ports;
        this.resolution = resolution;
        this.subjectAltNames = subjectAltNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("addresses")
    public List<String> getAddresses() {
        return addresses;
    }

    /**
     * 
     * 
     */
    @JsonProperty("addresses")
    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    /**
     * 
     * 
     */
    @JsonProperty("endpoints")
    public List<Endpoint> getEndpoints() {
        return endpoints;
    }

    /**
     * 
     * 
     */
    @JsonProperty("endpoints")
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exportTo")
    public List<String> getExportTo() {
        return exportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exportTo")
    public void setExportTo(List<String> exportTo) {
        this.exportTo = exportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    @JsonProperty("location")
    public ServiceEntryLocation getLocation() {
        return location;
    }

    @JsonProperty("location")
    public void setLocation(ServiceEntryLocation location) {
        this.location = location;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public List<Port> getPorts() {
        return ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public void setPorts(List<Port> ports) {
        this.ports = ports;
    }

    @JsonProperty("resolution")
    public ServiceEntryResolution getResolution() {
        return resolution;
    }

    @JsonProperty("resolution")
    public void setResolution(ServiceEntryResolution resolution) {
        this.resolution = resolution;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    public List<String> getSubjectAltNames() {
        return subjectAltNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

}
