
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "egress",
    "ingress",
    "workloadSelector"
})
@IstioKind(name = "Sidecar", plural = "sidecars")
@IstioApiVersion("networking.istio.io/v1alpha3")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class SidecarSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("egress")
    @JsonPropertyDescription("")
    private List<IstioEgressListener> egress = new ArrayList<IstioEgressListener>();
    /**
     * 
     * 
     */
    @JsonProperty("ingress")
    @JsonPropertyDescription("")
    private List<IstioIngressListener> ingress = new ArrayList<IstioIngressListener>();
    /**
     * 
     * 
     */
    @JsonProperty("workloadSelector")
    @JsonPropertyDescription("")
    private WorkloadSelector workloadSelector;
    private final static long serialVersionUID = 5983010536209465655L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SidecarSpec() {
    }

    /**
     * 
     * @param ingress
     * @param workloadSelector
     * @param egress
     */
    public SidecarSpec(List<IstioEgressListener> egress, List<IstioIngressListener> ingress, WorkloadSelector workloadSelector) {
        super();
        this.egress = egress;
        this.ingress = ingress;
        this.workloadSelector = workloadSelector;
    }

    /**
     * 
     * 
     */
    @JsonProperty("egress")
    public List<IstioEgressListener> getEgress() {
        return egress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("egress")
    public void setEgress(List<IstioEgressListener> egress) {
        this.egress = egress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingress")
    public List<IstioIngressListener> getIngress() {
        return ingress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingress")
    public void setIngress(List<IstioIngressListener> ingress) {
        this.ingress = ingress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("workloadSelector")
    public WorkloadSelector getWorkloadSelector() {
        return workloadSelector;
    }

    /**
     * 
     * 
     */
    @JsonProperty("workloadSelector")
    public void setWorkloadSelector(WorkloadSelector workloadSelector) {
        this.workloadSelector = workloadSelector;
    }

}
