package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;

public interface SidecarSpecFluent<A extends SidecarSpecFluent<A>> extends Fluent<A>{


    public A addToEgress(int index,IstioEgressListener item);
    public A setToEgress(int index,IstioEgressListener item);
    public A addToEgress(IstioEgressListener... items);
    public A addAllToEgress(Collection<IstioEgressListener> items);
    public A removeFromEgress(IstioEgressListener... items);
    public A removeAllFromEgress(Collection<IstioEgressListener> items);
    public A removeMatchingFromEgress(io.fabric8.kubernetes.api.builder.Predicate<IstioEgressListenerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEgress instead.
 * @return The buildable object.
 */
@Deprecated public List<IstioEgressListener> getEgress();
    public List<IstioEgressListener> buildEgress();
    public IstioEgressListener buildEgress(int index);
    public IstioEgressListener buildFirstEgress();
    public IstioEgressListener buildLastEgress();
    public IstioEgressListener buildMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<IstioEgressListenerBuilder> predicate);
    public Boolean hasMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<IstioEgressListenerBuilder> predicate);
    public A withEgress(List<IstioEgressListener> egress);
    public A withEgress(IstioEgressListener... egress);
    public Boolean hasEgress();
    public SidecarSpecFluent.EgressNested<A> addNewEgress();
    public SidecarSpecFluent.EgressNested<A> addNewEgressLike(IstioEgressListener item);
    public SidecarSpecFluent.EgressNested<A> setNewEgressLike(int index,IstioEgressListener item);
    public SidecarSpecFluent.EgressNested<A> editEgress(int index);
    public SidecarSpecFluent.EgressNested<A> editFirstEgress();
    public SidecarSpecFluent.EgressNested<A> editLastEgress();
    public SidecarSpecFluent.EgressNested<A> editMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<IstioEgressListenerBuilder> predicate);
    public A addToIngress(int index,IstioIngressListener item);
    public A setToIngress(int index,IstioIngressListener item);
    public A addToIngress(IstioIngressListener... items);
    public A addAllToIngress(Collection<IstioIngressListener> items);
    public A removeFromIngress(IstioIngressListener... items);
    public A removeAllFromIngress(Collection<IstioIngressListener> items);
    public A removeMatchingFromIngress(io.fabric8.kubernetes.api.builder.Predicate<IstioIngressListenerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildIngress instead.
 * @return The buildable object.
 */
@Deprecated public List<IstioIngressListener> getIngress();
    public List<IstioIngressListener> buildIngress();
    public IstioIngressListener buildIngress(int index);
    public IstioIngressListener buildFirstIngress();
    public IstioIngressListener buildLastIngress();
    public IstioIngressListener buildMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<IstioIngressListenerBuilder> predicate);
    public Boolean hasMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<IstioIngressListenerBuilder> predicate);
    public A withIngress(List<IstioIngressListener> ingress);
    public A withIngress(IstioIngressListener... ingress);
    public Boolean hasIngress();
    public SidecarSpecFluent.IngressNested<A> addNewIngress();
    public SidecarSpecFluent.IngressNested<A> addNewIngressLike(IstioIngressListener item);
    public SidecarSpecFluent.IngressNested<A> setNewIngressLike(int index,IstioIngressListener item);
    public SidecarSpecFluent.IngressNested<A> editIngress(int index);
    public SidecarSpecFluent.IngressNested<A> editFirstIngress();
    public SidecarSpecFluent.IngressNested<A> editLastIngress();
    public SidecarSpecFluent.IngressNested<A> editMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<IstioIngressListenerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildWorkloadSelector instead.
 * @return The buildable object.
 */
@Deprecated public WorkloadSelector getWorkloadSelector();
    public WorkloadSelector buildWorkloadSelector();
    public A withWorkloadSelector(WorkloadSelector workloadSelector);
    public Boolean hasWorkloadSelector();
    public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector();
    public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item);
    public SidecarSpecFluent.WorkloadSelectorNested<A> editWorkloadSelector();
    public SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector();
    public SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item);

    public interface EgressNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IstioEgressListenerFluent<SidecarSpecFluent.EgressNested<N>>{

        
    public N and();    public N endEgress();
}
    public interface IngressNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IstioIngressListenerFluent<SidecarSpecFluent.IngressNested<N>>{

        
    public N and();    public N endIngress();
}
    public interface WorkloadSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,WorkloadSelectorFluent<SidecarSpecFluent.WorkloadSelectorNested<N>>{

        
    public N and();    public N endWorkloadSelector();
}


}
