package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SimpleLbPolicyBuilder extends SimpleLbPolicyFluentImpl<SimpleLbPolicyBuilder> implements VisitableBuilder<SimpleLbPolicy,SimpleLbPolicyBuilder>{

    SimpleLbPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public SimpleLbPolicyBuilder(){
            this(true);
    }
    public SimpleLbPolicyBuilder(Boolean validationEnabled){
            this(new SimpleLbPolicy(), validationEnabled);
    }
    public SimpleLbPolicyBuilder(SimpleLbPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public SimpleLbPolicyBuilder(SimpleLbPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SimpleLbPolicy(), validationEnabled);
    }
    public SimpleLbPolicyBuilder(SimpleLbPolicyFluent<?> fluent,SimpleLbPolicy instance){
            this(fluent, instance, true);
    }
    public SimpleLbPolicyBuilder(SimpleLbPolicyFluent<?> fluent,SimpleLbPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSimple(instance.getSimple()); 
            this.validationEnabled = validationEnabled; 
    }
    public SimpleLbPolicyBuilder(SimpleLbPolicy instance){
            this(instance,true);
    }
    public SimpleLbPolicyBuilder(SimpleLbPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSimple(instance.getSimple()); 
            this.validationEnabled = validationEnabled; 
    }

    public SimpleLbPolicy build(){
            SimpleLbPolicy buildable = new SimpleLbPolicy(fluent.getSimple());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SimpleLbPolicyBuilder that = (SimpleLbPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
