package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Boolean;
import java.util.Map;

public interface SubsetFluent<A extends SubsetFluent<A>> extends Fluent<A>{


    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public TrafficPolicy getTrafficPolicy();
    public TrafficPolicy buildTrafficPolicy();
    public A withTrafficPolicy(TrafficPolicy trafficPolicy);
    public Boolean hasTrafficPolicy();
    public SubsetFluent.TrafficPolicyNested<A> withNewTrafficPolicy();
    public SubsetFluent.TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item);
    public SubsetFluent.TrafficPolicyNested<A> editTrafficPolicy();
    public SubsetFluent.TrafficPolicyNested<A> editOrNewTrafficPolicy();
    public SubsetFluent.TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item);

    public interface TrafficPolicyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TrafficPolicyFluent<SubsetFluent.TrafficPolicyNested<N>>{

        
    public N and();    public N endTrafficPolicy();
}


}
