
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "match",
    "route"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TCPRoute implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    private List<L4MatchAttributes> match = new ArrayList<L4MatchAttributes>();
    /**
     * 
     * 
     */
    @JsonProperty("route")
    @JsonPropertyDescription("")
    private List<RouteDestination> route = new ArrayList<RouteDestination>();
    private final static long serialVersionUID = -9065489218989803086L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TCPRoute() {
    }

    /**
     * 
     * @param route
     * @param match
     */
    public TCPRoute(List<L4MatchAttributes> match, List<RouteDestination> route) {
        super();
        this.match = match;
        this.route = route;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public List<L4MatchAttributes> getMatch() {
        return match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public void setMatch(List<L4MatchAttributes> match) {
        this.match = match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("route")
    public List<RouteDestination> getRoute() {
        return route;
    }

    /**
     * 
     * 
     */
    @JsonProperty("route")
    public void setRoute(List<RouteDestination> route) {
        this.route = route;
    }

}
