package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TCPRouteBuilder extends TCPRouteFluentImpl<TCPRouteBuilder> implements VisitableBuilder<TCPRoute,TCPRouteBuilder>{

    TCPRouteFluent<?> fluent;
    Boolean validationEnabled;

    public TCPRouteBuilder(){
            this(true);
    }
    public TCPRouteBuilder(Boolean validationEnabled){
            this(new TCPRoute(), validationEnabled);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent){
            this(fluent, true);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TCPRoute(), validationEnabled);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance){
            this(fluent, instance, true);
    }
    public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMatch(instance.getMatch()); 
            fluent.withRoute(instance.getRoute()); 
            this.validationEnabled = validationEnabled; 
    }
    public TCPRouteBuilder(TCPRoute instance){
            this(instance,true);
    }
    public TCPRouteBuilder(TCPRoute instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMatch(instance.getMatch()); 
            this.withRoute(instance.getRoute()); 
            this.validationEnabled = validationEnabled; 
    }

    public TCPRoute build(){
            TCPRoute buildable = new TCPRoute(fluent.getMatch(),fluent.getRoute());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TCPRouteBuilder that = (TCPRouteBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
