package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class TCPRouteFluentImpl<A extends TCPRouteFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TCPRouteFluent<A>{

    private List<L4MatchAttributesBuilder> match;
    private List<RouteDestinationBuilder> route;

    public TCPRouteFluentImpl(){
    }
    public TCPRouteFluentImpl(TCPRoute instance){
            this.withMatch(instance.getMatch()); 
            this.withRoute(instance.getRoute()); 
    }

    public A addToMatch(int index,L4MatchAttributes item){
            if (this.match == null) {this.match = new ArrayList<L4MatchAttributesBuilder>();}
            L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.get("match").add(index >= 0 ? index : _visitables.get("match").size(), builder);this.match.add(index >= 0 ? index : match.size(), builder); return (A)this;
    }

    public A setToMatch(int index,L4MatchAttributes item){
            if (this.match == null) {this.match = new ArrayList<L4MatchAttributesBuilder>();}
            L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);
            if (index < 0 || index >= _visitables.get("match").size()) { _visitables.get("match").add(builder); } else { _visitables.get("match").set(index, builder);}
            if (index < 0 || index >= match.size()) { match.add(builder); } else { match.set(index, builder);}
             return (A)this;
    }

    public A addToMatch(L4MatchAttributes... items){
            if (this.match == null) {this.match = new ArrayList<L4MatchAttributesBuilder>();}
            for (L4MatchAttributes item : items) {L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
    }

    public A addAllToMatch(Collection<L4MatchAttributes> items){
            if (this.match == null) {this.match = new ArrayList<L4MatchAttributesBuilder>();}
            for (L4MatchAttributes item : items) {L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
    }

    public A removeFromMatch(L4MatchAttributes... items){
            for (L4MatchAttributes item : items) {L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatch(Collection<L4MatchAttributes> items){
            for (L4MatchAttributes item : items) {L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMatch(io.fabric8.kubernetes.api.builder.Predicate<L4MatchAttributesBuilder> predicate){
            if (match == null) return (A) this;
            final Iterator<L4MatchAttributesBuilder> each = match.iterator();
            final List visitables = _visitables.get("match");
            while (each.hasNext()) {
              L4MatchAttributesBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatch instead.
 * @return The buildable object.
 */
@Deprecated public List<L4MatchAttributes> getMatch(){
            return build(match);
    }

    public List<L4MatchAttributes> buildMatch(){
            return build(match);
    }

    public L4MatchAttributes buildMatch(int index){
            return this.match.get(index).build();
    }

    public L4MatchAttributes buildFirstMatch(){
            return this.match.get(0).build();
    }

    public L4MatchAttributes buildLastMatch(){
            return this.match.get(match.size() - 1).build();
    }

    public L4MatchAttributes buildMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<L4MatchAttributesBuilder> predicate){
            for (L4MatchAttributesBuilder item: match) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<L4MatchAttributesBuilder> predicate){
            for (L4MatchAttributesBuilder item: match) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMatch(List<L4MatchAttributes> match){
            if (this.match != null) { _visitables.get("match").removeAll(this.match);}
            if (match != null) {this.match = new ArrayList<L4MatchAttributesBuilder>(); for (L4MatchAttributes item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
    }

    public A withMatch(L4MatchAttributes... match){
            if (this.match != null) {this.match.clear();}
            if (match != null) {for (L4MatchAttributes item :match){ this.addToMatch(item);}} return (A) this;
    }

    public Boolean hasMatch(){
            return match != null && !match.isEmpty();
    }

    public TCPRouteFluent.MatchNested<A> addNewMatch(){
            return new MatchNestedImpl();
    }

    public TCPRouteFluent.MatchNested<A> addNewMatchLike(L4MatchAttributes item){
            return new MatchNestedImpl(-1, item);
    }

    public TCPRouteFluent.MatchNested<A> setNewMatchLike(int index,L4MatchAttributes item){
            return new MatchNestedImpl(index, item);
    }

    public TCPRouteFluent.MatchNested<A> editMatch(int index){
            if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public TCPRouteFluent.MatchNested<A> editFirstMatch(){
            if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
            return setNewMatchLike(0, buildMatch(0));
    }

    public TCPRouteFluent.MatchNested<A> editLastMatch(){
            int index = match.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public TCPRouteFluent.MatchNested<A> editMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<L4MatchAttributesBuilder> predicate){
            int index = -1;
            for (int i=0;i<match.size();i++) { 
            if (predicate.apply(match.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public A addToRoute(int index,RouteDestination item){
            if (this.route == null) {this.route = new ArrayList<RouteDestinationBuilder>();}
            RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").add(index >= 0 ? index : _visitables.get("route").size(), builder);this.route.add(index >= 0 ? index : route.size(), builder); return (A)this;
    }

    public A setToRoute(int index,RouteDestination item){
            if (this.route == null) {this.route = new ArrayList<RouteDestinationBuilder>();}
            RouteDestinationBuilder builder = new RouteDestinationBuilder(item);
            if (index < 0 || index >= _visitables.get("route").size()) { _visitables.get("route").add(builder); } else { _visitables.get("route").set(index, builder);}
            if (index < 0 || index >= route.size()) { route.add(builder); } else { route.set(index, builder);}
             return (A)this;
    }

    public A addToRoute(RouteDestination... items){
            if (this.route == null) {this.route = new ArrayList<RouteDestinationBuilder>();}
            for (RouteDestination item : items) {RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
    }

    public A addAllToRoute(Collection<RouteDestination> items){
            if (this.route == null) {this.route = new ArrayList<RouteDestinationBuilder>();}
            for (RouteDestination item : items) {RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
    }

    public A removeFromRoute(RouteDestination... items){
            for (RouteDestination item : items) {RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoute(Collection<RouteDestination> items){
            for (RouteDestination item : items) {RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRoute(io.fabric8.kubernetes.api.builder.Predicate<RouteDestinationBuilder> predicate){
            if (route == null) return (A) this;
            final Iterator<RouteDestinationBuilder> each = route.iterator();
            final List visitables = _visitables.get("route");
            while (each.hasNext()) {
              RouteDestinationBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRoute instead.
 * @return The buildable object.
 */
@Deprecated public List<RouteDestination> getRoute(){
            return build(route);
    }

    public List<RouteDestination> buildRoute(){
            return build(route);
    }

    public RouteDestination buildRoute(int index){
            return this.route.get(index).build();
    }

    public RouteDestination buildFirstRoute(){
            return this.route.get(0).build();
    }

    public RouteDestination buildLastRoute(){
            return this.route.get(route.size() - 1).build();
    }

    public RouteDestination buildMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<RouteDestinationBuilder> predicate){
            for (RouteDestinationBuilder item: route) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<RouteDestinationBuilder> predicate){
            for (RouteDestinationBuilder item: route) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRoute(List<RouteDestination> route){
            if (this.route != null) { _visitables.get("route").removeAll(this.route);}
            if (route != null) {this.route = new ArrayList<RouteDestinationBuilder>(); for (RouteDestination item : route){this.addToRoute(item);}} else { this.route = null;} return (A) this;
    }

    public A withRoute(RouteDestination... route){
            if (this.route != null) {this.route.clear();}
            if (route != null) {for (RouteDestination item :route){ this.addToRoute(item);}} return (A) this;
    }

    public Boolean hasRoute(){
            return route != null && !route.isEmpty();
    }

    public TCPRouteFluent.RouteNested<A> addNewRoute(){
            return new RouteNestedImpl();
    }

    public TCPRouteFluent.RouteNested<A> addNewRouteLike(RouteDestination item){
            return new RouteNestedImpl(-1, item);
    }

    public TCPRouteFluent.RouteNested<A> setNewRouteLike(int index,RouteDestination item){
            return new RouteNestedImpl(index, item);
    }

    public TCPRouteFluent.RouteNested<A> editRoute(int index){
            if (route.size() <= index) throw new RuntimeException("Can't edit route. Index exceeds size.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public TCPRouteFluent.RouteNested<A> editFirstRoute(){
            if (route.size() == 0) throw new RuntimeException("Can't edit first route. The list is empty.");
            return setNewRouteLike(0, buildRoute(0));
    }

    public TCPRouteFluent.RouteNested<A> editLastRoute(){
            int index = route.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last route. The list is empty.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public TCPRouteFluent.RouteNested<A> editMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<RouteDestinationBuilder> predicate){
            int index = -1;
            for (int i=0;i<route.size();i++) { 
            if (predicate.apply(route.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching route. No match found.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TCPRouteFluentImpl that = (TCPRouteFluentImpl) o;
            if (match != null ? !match.equals(that.match) :that.match != null) return false;
            if (route != null ? !route.equals(that.route) :that.route != null) return false;
            return true;
    }


    public class MatchNestedImpl<N> extends L4MatchAttributesFluentImpl<TCPRouteFluent.MatchNested<N>> implements TCPRouteFluent.MatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final L4MatchAttributesBuilder builder;
        private final int index;
    
            MatchNestedImpl(int index,L4MatchAttributes item){
                    this.index = index;
                    this.builder = new L4MatchAttributesBuilder(this, item);
            }
            MatchNestedImpl(){
                    this.index = -1;
                    this.builder = new L4MatchAttributesBuilder(this);
            }
    
    public N and(){
            return (N) TCPRouteFluentImpl.this.setToMatch(index, builder.build());
    }
    public N endMatch(){
            return and();
    }

}
    public class RouteNestedImpl<N> extends RouteDestinationFluentImpl<TCPRouteFluent.RouteNested<N>> implements TCPRouteFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteDestinationBuilder builder;
        private final int index;
    
            RouteNestedImpl(int index,RouteDestination item){
                    this.index = index;
                    this.builder = new RouteDestinationBuilder(this, item);
            }
            RouteNestedImpl(){
                    this.index = -1;
                    this.builder = new RouteDestinationBuilder(this);
            }
    
    public N and(){
            return (N) TCPRouteFluentImpl.this.setToRoute(index, builder.build());
    }
    public N endRoute(){
            return and();
    }

}


}
