
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "destinationSubnets",
    "gateways",
    "port",
    "sniHosts",
    "sourceLabels",
    "sourceSubnet"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TLSMatchAttributes implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("destinationSubnets")
    @JsonPropertyDescription("")
    private List<java.lang.String> destinationSubnets = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    @JsonPropertyDescription("")
    private List<java.lang.String> gateways = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Integer port;
    /**
     * 
     * 
     */
    @JsonProperty("sniHosts")
    @JsonPropertyDescription("")
    private List<java.lang.String> sniHosts = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    @JsonPropertyDescription("")
    private Map<String, String> sourceLabels;
    /**
     * 
     * 
     */
    @JsonProperty("sourceSubnet")
    @JsonPropertyDescription("")
    private java.lang.String sourceSubnet;
    private final static long serialVersionUID = 4432894473973625939L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TLSMatchAttributes() {
    }

    /**
     * 
     * @param gateways
     * @param sniHosts
     * @param destinationSubnets
     * @param sourceSubnet
     * @param port
     * @param sourceLabels
     */
    public TLSMatchAttributes(List<java.lang.String> destinationSubnets, List<java.lang.String> gateways, Integer port, List<java.lang.String> sniHosts, Map<String, String> sourceLabels, java.lang.String sourceSubnet) {
        super();
        this.destinationSubnets = destinationSubnets;
        this.gateways = gateways;
        this.port = port;
        this.sniHosts = sniHosts;
        this.sourceLabels = sourceLabels;
        this.sourceSubnet = sourceSubnet;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationSubnets")
    public List<java.lang.String> getDestinationSubnets() {
        return destinationSubnets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationSubnets")
    public void setDestinationSubnets(List<java.lang.String> destinationSubnets) {
        this.destinationSubnets = destinationSubnets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    public List<java.lang.String> getGateways() {
        return gateways;
    }

    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    public void setGateways(List<java.lang.String> gateways) {
        this.gateways = gateways;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public Integer getPort() {
        return port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sniHosts")
    public List<java.lang.String> getSniHosts() {
        return sniHosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sniHosts")
    public void setSniHosts(List<java.lang.String> sniHosts) {
        this.sniHosts = sniHosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    public Map<String, String> getSourceLabels() {
        return sourceLabels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceSubnet")
    public java.lang.String getSourceSubnet() {
        return sourceSubnet;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceSubnet")
    public void setSourceSubnet(java.lang.String sourceSubnet) {
        this.sourceSubnet = sourceSubnet;
    }

}
