
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "caCertificates",
    "cipherSuites",
    "credentialName",
    "httpsRedirect",
    "maxProtocolVersion",
    "minProtocolVersion",
    "mode",
    "privateKey",
    "serverCertificate",
    "subjectAltNames"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TLSOptions implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("caCertificates")
    @JsonPropertyDescription("")
    private String caCertificates;
    /**
     * 
     * 
     */
    @JsonProperty("cipherSuites")
    @JsonPropertyDescription("")
    private List<String> cipherSuites = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("credentialName")
    @JsonPropertyDescription("")
    private String credentialName;
    /**
     * 
     * 
     */
    @JsonProperty("httpsRedirect")
    @JsonPropertyDescription("")
    private Boolean httpsRedirect;
    @JsonProperty("maxProtocolVersion")
    private me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsProtocol maxProtocolVersion;
    @JsonProperty("minProtocolVersion")
    private me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsProtocol minProtocolVersion;
    @JsonProperty("mode")
    private TLSOptionsMode mode;
    /**
     * 
     * 
     */
    @JsonProperty("privateKey")
    @JsonPropertyDescription("")
    private String privateKey;
    /**
     * 
     * 
     */
    @JsonProperty("serverCertificate")
    @JsonPropertyDescription("")
    private String serverCertificate;
    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    @JsonPropertyDescription("")
    private List<String> subjectAltNames = new ArrayList<String>();
    private final static long serialVersionUID = 3084286947298553107L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TLSOptions() {
    }

    /**
     * 
     * @param mode
     * @param privateKey
     * @param caCertificates
     * @param serverCertificate
     * @param cipherSuites
     * @param httpsRedirect
     * @param maxProtocolVersion
     * @param subjectAltNames
     * @param credentialName
     * @param minProtocolVersion
     */
    public TLSOptions(String caCertificates, List<String> cipherSuites, String credentialName, Boolean httpsRedirect, me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsProtocol maxProtocolVersion, me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsProtocol minProtocolVersion, TLSOptionsMode mode, String privateKey, String serverCertificate, List<String> subjectAltNames) {
        super();
        this.caCertificates = caCertificates;
        this.cipherSuites = cipherSuites;
        this.credentialName = credentialName;
        this.httpsRedirect = httpsRedirect;
        this.maxProtocolVersion = maxProtocolVersion;
        this.minProtocolVersion = minProtocolVersion;
        this.mode = mode;
        this.privateKey = privateKey;
        this.serverCertificate = serverCertificate;
        this.subjectAltNames = subjectAltNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("caCertificates")
    public String getCaCertificates() {
        return caCertificates;
    }

    /**
     * 
     * 
     */
    @JsonProperty("caCertificates")
    public void setCaCertificates(String caCertificates) {
        this.caCertificates = caCertificates;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cipherSuites")
    public List<String> getCipherSuites() {
        return cipherSuites;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cipherSuites")
    public void setCipherSuites(List<String> cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    /**
     * 
     * 
     */
    @JsonProperty("credentialName")
    public String getCredentialName() {
        return credentialName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("credentialName")
    public void setCredentialName(String credentialName) {
        this.credentialName = credentialName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpsRedirect")
    public Boolean getHttpsRedirect() {
        return httpsRedirect;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpsRedirect")
    public void setHttpsRedirect(Boolean httpsRedirect) {
        this.httpsRedirect = httpsRedirect;
    }

    @JsonProperty("maxProtocolVersion")
    public me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsProtocol getMaxProtocolVersion() {
        return maxProtocolVersion;
    }

    @JsonProperty("maxProtocolVersion")
    public void setMaxProtocolVersion(me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsProtocol maxProtocolVersion) {
        this.maxProtocolVersion = maxProtocolVersion;
    }

    @JsonProperty("minProtocolVersion")
    public me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsProtocol getMinProtocolVersion() {
        return minProtocolVersion;
    }

    @JsonProperty("minProtocolVersion")
    public void setMinProtocolVersion(me.snowdrop.istio.api.networking.v1alpha3.TLSOptionsProtocol minProtocolVersion) {
        this.minProtocolVersion = minProtocolVersion;
    }

    @JsonProperty("mode")
    public TLSOptionsMode getMode() {
        return mode;
    }

    @JsonProperty("mode")
    public void setMode(TLSOptionsMode mode) {
        this.mode = mode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("privateKey")
    public String getPrivateKey() {
        return privateKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("privateKey")
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("serverCertificate")
    public String getServerCertificate() {
        return serverCertificate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("serverCertificate")
    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    public List<String> getSubjectAltNames() {
        return subjectAltNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

}
