package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TLSOptionsBuilder extends TLSOptionsFluentImpl<TLSOptionsBuilder> implements VisitableBuilder<TLSOptions,TLSOptionsBuilder>{

    TLSOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public TLSOptionsBuilder(){
            this(true);
    }
    public TLSOptionsBuilder(Boolean validationEnabled){
            this(new TLSOptions(), validationEnabled);
    }
    public TLSOptionsBuilder(TLSOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public TLSOptionsBuilder(TLSOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TLSOptions(), validationEnabled);
    }
    public TLSOptionsBuilder(TLSOptionsFluent<?> fluent,TLSOptions instance){
            this(fluent, instance, true);
    }
    public TLSOptionsBuilder(TLSOptionsFluent<?> fluent,TLSOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCaCertificates(instance.getCaCertificates()); 
            fluent.withCipherSuites(instance.getCipherSuites()); 
            fluent.withCredentialName(instance.getCredentialName()); 
            fluent.withHttpsRedirect(instance.getHttpsRedirect()); 
            fluent.withMaxProtocolVersion(instance.getMaxProtocolVersion()); 
            fluent.withMinProtocolVersion(instance.getMinProtocolVersion()); 
            fluent.withMode(instance.getMode()); 
            fluent.withPrivateKey(instance.getPrivateKey()); 
            fluent.withServerCertificate(instance.getServerCertificate()); 
            fluent.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.validationEnabled = validationEnabled; 
    }
    public TLSOptionsBuilder(TLSOptions instance){
            this(instance,true);
    }
    public TLSOptionsBuilder(TLSOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCaCertificates(instance.getCaCertificates()); 
            this.withCipherSuites(instance.getCipherSuites()); 
            this.withCredentialName(instance.getCredentialName()); 
            this.withHttpsRedirect(instance.getHttpsRedirect()); 
            this.withMaxProtocolVersion(instance.getMaxProtocolVersion()); 
            this.withMinProtocolVersion(instance.getMinProtocolVersion()); 
            this.withMode(instance.getMode()); 
            this.withPrivateKey(instance.getPrivateKey()); 
            this.withServerCertificate(instance.getServerCertificate()); 
            this.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.validationEnabled = validationEnabled; 
    }

    public TLSOptions build(){
            TLSOptions buildable = new TLSOptions(fluent.getCaCertificates(),fluent.getCipherSuites(),fluent.getCredentialName(),fluent.isHttpsRedirect(),fluent.getMaxProtocolVersion(),fluent.getMinProtocolVersion(),fluent.getMode(),fluent.getPrivateKey(),fluent.getServerCertificate(),fluent.getSubjectAltNames());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TLSOptionsBuilder that = (TLSOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
