package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TLSRouteBuilder extends TLSRouteFluentImpl<TLSRouteBuilder> implements VisitableBuilder<TLSRoute,TLSRouteBuilder>{

    TLSRouteFluent<?> fluent;
    Boolean validationEnabled;

    public TLSRouteBuilder(){
            this(true);
    }
    public TLSRouteBuilder(Boolean validationEnabled){
            this(new TLSRoute(), validationEnabled);
    }
    public TLSRouteBuilder(TLSRouteFluent<?> fluent){
            this(fluent, true);
    }
    public TLSRouteBuilder(TLSRouteFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TLSRoute(), validationEnabled);
    }
    public TLSRouteBuilder(TLSRouteFluent<?> fluent,TLSRoute instance){
            this(fluent, instance, true);
    }
    public TLSRouteBuilder(TLSRouteFluent<?> fluent,TLSRoute instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMatch(instance.getMatch()); 
            fluent.withRoute(instance.getRoute()); 
            this.validationEnabled = validationEnabled; 
    }
    public TLSRouteBuilder(TLSRoute instance){
            this(instance,true);
    }
    public TLSRouteBuilder(TLSRoute instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMatch(instance.getMatch()); 
            this.withRoute(instance.getRoute()); 
            this.validationEnabled = validationEnabled; 
    }

    public TLSRoute build(){
            TLSRoute buildable = new TLSRoute(fluent.getMatch(),fluent.getRoute());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TLSRouteBuilder that = (TLSRouteBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
