
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "caCertificates",
    "clientCertificate",
    "mode",
    "privateKey",
    "sni",
    "subjectAltNames"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TLSSettings implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("caCertificates")
    @JsonPropertyDescription("")
    private String caCertificates;
    /**
     * 
     * 
     */
    @JsonProperty("clientCertificate")
    @JsonPropertyDescription("")
    private String clientCertificate;
    @JsonProperty("mode")
    private TLSSettingsMode mode;
    /**
     * 
     * 
     */
    @JsonProperty("privateKey")
    @JsonPropertyDescription("")
    private String privateKey;
    /**
     * 
     * 
     */
    @JsonProperty("sni")
    @JsonPropertyDescription("")
    private String sni;
    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    @JsonPropertyDescription("")
    private List<String> subjectAltNames = new ArrayList<String>();
    private final static long serialVersionUID = -3518674295563341638L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TLSSettings() {
    }

    /**
     * 
     * @param mode
     * @param privateKey
     * @param clientCertificate
     * @param caCertificates
     * @param subjectAltNames
     * @param sni
     */
    public TLSSettings(String caCertificates, String clientCertificate, TLSSettingsMode mode, String privateKey, String sni, List<String> subjectAltNames) {
        super();
        this.caCertificates = caCertificates;
        this.clientCertificate = clientCertificate;
        this.mode = mode;
        this.privateKey = privateKey;
        this.sni = sni;
        this.subjectAltNames = subjectAltNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("caCertificates")
    public String getCaCertificates() {
        return caCertificates;
    }

    /**
     * 
     * 
     */
    @JsonProperty("caCertificates")
    public void setCaCertificates(String caCertificates) {
        this.caCertificates = caCertificates;
    }

    /**
     * 
     * 
     */
    @JsonProperty("clientCertificate")
    public String getClientCertificate() {
        return clientCertificate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("clientCertificate")
    public void setClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    @JsonProperty("mode")
    public TLSSettingsMode getMode() {
        return mode;
    }

    @JsonProperty("mode")
    public void setMode(TLSSettingsMode mode) {
        this.mode = mode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("privateKey")
    public String getPrivateKey() {
        return privateKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("privateKey")
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sni")
    public String getSni() {
        return sni;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sni")
    public void setSni(String sni) {
        this.sni = sni;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    public List<String> getSubjectAltNames() {
        return subjectAltNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subjectAltNames")
    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

}
