package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TLSSettingsBuilder extends TLSSettingsFluentImpl<TLSSettingsBuilder> implements VisitableBuilder<TLSSettings,TLSSettingsBuilder>{

    TLSSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public TLSSettingsBuilder(){
            this(true);
    }
    public TLSSettingsBuilder(Boolean validationEnabled){
            this(new TLSSettings(), validationEnabled);
    }
    public TLSSettingsBuilder(TLSSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public TLSSettingsBuilder(TLSSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TLSSettings(), validationEnabled);
    }
    public TLSSettingsBuilder(TLSSettingsFluent<?> fluent,TLSSettings instance){
            this(fluent, instance, true);
    }
    public TLSSettingsBuilder(TLSSettingsFluent<?> fluent,TLSSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCaCertificates(instance.getCaCertificates()); 
            fluent.withClientCertificate(instance.getClientCertificate()); 
            fluent.withMode(instance.getMode()); 
            fluent.withPrivateKey(instance.getPrivateKey()); 
            fluent.withSni(instance.getSni()); 
            fluent.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.validationEnabled = validationEnabled; 
    }
    public TLSSettingsBuilder(TLSSettings instance){
            this(instance,true);
    }
    public TLSSettingsBuilder(TLSSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCaCertificates(instance.getCaCertificates()); 
            this.withClientCertificate(instance.getClientCertificate()); 
            this.withMode(instance.getMode()); 
            this.withPrivateKey(instance.getPrivateKey()); 
            this.withSni(instance.getSni()); 
            this.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.validationEnabled = validationEnabled; 
    }

    public TLSSettings build(){
            TLSSettings buildable = new TLSSettings(fluent.getCaCertificates(),fluent.getClientCertificate(),fluent.getMode(),fluent.getPrivateKey(),fluent.getSni(),fluent.getSubjectAltNames());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TLSSettingsBuilder that = (TLSSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
