package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TLSSettingsFluentImpl<A extends TLSSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TLSSettingsFluent<A>{

    private String caCertificates;
    private String clientCertificate;
    private TLSSettingsMode mode;
    private String privateKey;
    private String sni;
    private List<String> subjectAltNames;

    public TLSSettingsFluentImpl(){
    }
    public TLSSettingsFluentImpl(TLSSettings instance){
            this.withCaCertificates(instance.getCaCertificates()); 
            this.withClientCertificate(instance.getClientCertificate()); 
            this.withMode(instance.getMode()); 
            this.withPrivateKey(instance.getPrivateKey()); 
            this.withSni(instance.getSni()); 
            this.withSubjectAltNames(instance.getSubjectAltNames()); 
    }

    public String getCaCertificates(){
            return this.caCertificates;
    }

    public A withCaCertificates(String caCertificates){
            this.caCertificates=caCertificates; return (A) this;
    }

    public Boolean hasCaCertificates(){
            return this.caCertificates != null;
    }

    public A withNewCaCertificates(String arg1){
            return (A)withCaCertificates(new String(arg1));
    }

    public A withNewCaCertificates(StringBuilder arg1){
            return (A)withCaCertificates(new String(arg1));
    }

    public A withNewCaCertificates(StringBuffer arg1){
            return (A)withCaCertificates(new String(arg1));
    }

    public String getClientCertificate(){
            return this.clientCertificate;
    }

    public A withClientCertificate(String clientCertificate){
            this.clientCertificate=clientCertificate; return (A) this;
    }

    public Boolean hasClientCertificate(){
            return this.clientCertificate != null;
    }

    public A withNewClientCertificate(String arg1){
            return (A)withClientCertificate(new String(arg1));
    }

    public A withNewClientCertificate(StringBuilder arg1){
            return (A)withClientCertificate(new String(arg1));
    }

    public A withNewClientCertificate(StringBuffer arg1){
            return (A)withClientCertificate(new String(arg1));
    }

    public TLSSettingsMode getMode(){
            return this.mode;
    }

    public A withMode(TLSSettingsMode mode){
            this.mode=mode; return (A) this;
    }

    public Boolean hasMode(){
            return this.mode != null;
    }

    public String getPrivateKey(){
            return this.privateKey;
    }

    public A withPrivateKey(String privateKey){
            this.privateKey=privateKey; return (A) this;
    }

    public Boolean hasPrivateKey(){
            return this.privateKey != null;
    }

    public A withNewPrivateKey(String arg1){
            return (A)withPrivateKey(new String(arg1));
    }

    public A withNewPrivateKey(StringBuilder arg1){
            return (A)withPrivateKey(new String(arg1));
    }

    public A withNewPrivateKey(StringBuffer arg1){
            return (A)withPrivateKey(new String(arg1));
    }

    public String getSni(){
            return this.sni;
    }

    public A withSni(String sni){
            this.sni=sni; return (A) this;
    }

    public Boolean hasSni(){
            return this.sni != null;
    }

    public A withNewSni(String arg1){
            return (A)withSni(new String(arg1));
    }

    public A withNewSni(StringBuilder arg1){
            return (A)withSni(new String(arg1));
    }

    public A withNewSni(StringBuffer arg1){
            return (A)withSni(new String(arg1));
    }

    public A addToSubjectAltNames(int index,String item){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            this.subjectAltNames.add(index, item);
            return (A)this;
    }

    public A setToSubjectAltNames(int index,String item){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            this.subjectAltNames.set(index, item); return (A)this;
    }

    public A addToSubjectAltNames(String... items){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
    }

    public A addAllToSubjectAltNames(Collection<String> items){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
    }

    public A removeFromSubjectAltNames(String... items){
            for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
    }

    public A removeAllFromSubjectAltNames(Collection<String> items){
            for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
    }

    public List<String> getSubjectAltNames(){
            return this.subjectAltNames;
    }

    public String getSubjectAltName(int index){
            return this.subjectAltNames.get(index);
    }

    public String getFirstSubjectAltName(){
            return this.subjectAltNames.get(0);
    }

    public String getLastSubjectAltName(){
            return this.subjectAltNames.get(subjectAltNames.size() - 1);
    }

    public String getMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: subjectAltNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: subjectAltNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubjectAltNames(List<String> subjectAltNames){
            if (this.subjectAltNames != null) { _visitables.get("subjectAltNames").removeAll(this.subjectAltNames);}
            if (subjectAltNames != null) {this.subjectAltNames = new ArrayList<String>(); for (String item : subjectAltNames){this.addToSubjectAltNames(item);}} else { this.subjectAltNames = null;} return (A) this;
    }

    public A withSubjectAltNames(String... subjectAltNames){
            if (this.subjectAltNames != null) {this.subjectAltNames.clear();}
            if (subjectAltNames != null) {for (String item :subjectAltNames){ this.addToSubjectAltNames(item);}} return (A) this;
    }

    public Boolean hasSubjectAltNames(){
            return subjectAltNames != null && !subjectAltNames.isEmpty();
    }

    public A addNewSubjectAltName(String arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    public A addNewSubjectAltName(StringBuilder arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    public A addNewSubjectAltName(StringBuffer arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TLSSettingsFluentImpl that = (TLSSettingsFluentImpl) o;
            if (caCertificates != null ? !caCertificates.equals(that.caCertificates) :that.caCertificates != null) return false;
            if (clientCertificate != null ? !clientCertificate.equals(that.clientCertificate) :that.clientCertificate != null) return false;
            if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
            if (privateKey != null ? !privateKey.equals(that.privateKey) :that.privateKey != null) return false;
            if (sni != null ? !sni.equals(that.sni) :that.sni != null) return false;
            if (subjectAltNames != null ? !subjectAltNames.equals(that.subjectAltNames) :that.subjectAltNames != null) return false;
            return true;
    }




}
