
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "interval",
    "probes",
    "time"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TcpKeepalive implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("interval")
    @JsonPropertyDescription("")
    private Duration interval;
    /**
     * 
     * 
     */
    @JsonProperty("probes")
    @JsonPropertyDescription("")
    private Integer probes;
    /**
     * 
     * 
     */
    @JsonProperty("time")
    @JsonPropertyDescription("")
    private Duration time;
    private final static long serialVersionUID = 9180060786478365517L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TcpKeepalive() {
    }

    /**
     * 
     * @param interval
     * @param probes
     * @param time
     */
    public TcpKeepalive(Duration interval, Integer probes, Duration time) {
        super();
        this.interval = interval;
        this.probes = probes;
        this.time = time;
    }

    /**
     * 
     * 
     */
    @JsonProperty("interval")
    public Duration getInterval() {
        return interval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("interval")
    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("probes")
    public Integer getProbes() {
        return probes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("probes")
    public void setProbes(Integer probes) {
        this.probes = probes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("time")
    public Duration getTime() {
        return time;
    }

    /**
     * 
     * 
     */
    @JsonProperty("time")
    public void setTime(Duration time) {
        this.time = time;
    }

}
