package me.snowdrop.istio.api.networking.v1alpha3;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class TcpKeepaliveFluentImpl<A extends TcpKeepaliveFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TcpKeepaliveFluent<A>{

    private DurationBuilder interval;
    private Integer probes;
    private DurationBuilder time;

    public TcpKeepaliveFluentImpl(){
    }
    public TcpKeepaliveFluentImpl(TcpKeepalive instance){
            this.withInterval(instance.getInterval()); 
            this.withProbes(instance.getProbes()); 
            this.withTime(instance.getTime()); 
    }

    
/**
 * This method has been deprecated, please use method buildInterval instead.
 * @return The buildable object.
 */
@Deprecated public Duration getInterval(){
            return this.interval!=null?this.interval.build():null;
    }

    public Duration buildInterval(){
            return this.interval!=null?this.interval.build():null;
    }

    public A withInterval(Duration interval){
            _visitables.get("interval").remove(this.interval);
            if (interval!=null){ this.interval= new DurationBuilder(interval); _visitables.get("interval").add(this.interval);} return (A) this;
    }

    public Boolean hasInterval(){
            return this.interval != null;
    }

    public A withNewInterval(Integer nanos,Long seconds){
            return (A)withInterval(new Duration(nanos, seconds));
    }

    public TcpKeepaliveFluent.IntervalNested<A> withNewInterval(){
            return new IntervalNestedImpl();
    }

    public TcpKeepaliveFluent.IntervalNested<A> withNewIntervalLike(Duration item){
            return new IntervalNestedImpl(item);
    }

    public TcpKeepaliveFluent.IntervalNested<A> editInterval(){
            return withNewIntervalLike(getInterval());
    }

    public TcpKeepaliveFluent.IntervalNested<A> editOrNewInterval(){
            return withNewIntervalLike(getInterval() != null ? getInterval(): new DurationBuilder().build());
    }

    public TcpKeepaliveFluent.IntervalNested<A> editOrNewIntervalLike(Duration item){
            return withNewIntervalLike(getInterval() != null ? getInterval(): item);
    }

    public Integer getProbes(){
            return this.probes;
    }

    public A withProbes(Integer probes){
            this.probes=probes; return (A) this;
    }

    public Boolean hasProbes(){
            return this.probes != null;
    }

    
/**
 * This method has been deprecated, please use method buildTime instead.
 * @return The buildable object.
 */
@Deprecated public Duration getTime(){
            return this.time!=null?this.time.build():null;
    }

    public Duration buildTime(){
            return this.time!=null?this.time.build():null;
    }

    public A withTime(Duration time){
            _visitables.get("time").remove(this.time);
            if (time!=null){ this.time= new DurationBuilder(time); _visitables.get("time").add(this.time);} return (A) this;
    }

    public Boolean hasTime(){
            return this.time != null;
    }

    public A withNewTime(Integer nanos,Long seconds){
            return (A)withTime(new Duration(nanos, seconds));
    }

    public TcpKeepaliveFluent.TimeNested<A> withNewTime(){
            return new TimeNestedImpl();
    }

    public TcpKeepaliveFluent.TimeNested<A> withNewTimeLike(Duration item){
            return new TimeNestedImpl(item);
    }

    public TcpKeepaliveFluent.TimeNested<A> editTime(){
            return withNewTimeLike(getTime());
    }

    public TcpKeepaliveFluent.TimeNested<A> editOrNewTime(){
            return withNewTimeLike(getTime() != null ? getTime(): new DurationBuilder().build());
    }

    public TcpKeepaliveFluent.TimeNested<A> editOrNewTimeLike(Duration item){
            return withNewTimeLike(getTime() != null ? getTime(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TcpKeepaliveFluentImpl that = (TcpKeepaliveFluentImpl) o;
            if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
            if (probes != null ? !probes.equals(that.probes) :that.probes != null) return false;
            if (time != null ? !time.equals(that.time) :that.time != null) return false;
            return true;
    }


    public class IntervalNestedImpl<N> extends DurationFluentImpl<TcpKeepaliveFluent.IntervalNested<N>> implements TcpKeepaliveFluent.IntervalNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            IntervalNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            IntervalNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) TcpKeepaliveFluentImpl.this.withInterval(builder.build());
    }
    public N endInterval(){
            return and();
    }

}
    public class TimeNestedImpl<N> extends DurationFluentImpl<TcpKeepaliveFluent.TimeNested<N>> implements TcpKeepaliveFluent.TimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            TimeNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            TimeNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) TcpKeepaliveFluentImpl.this.withTime(builder.build());
    }
    public N endTime(){
            return and();
    }

}


}
