
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "connectionPool",
    "loadBalancer",
    "outlierDetection",
    "portLevelSettings",
    "tls"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TrafficPolicy implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("connectionPool")
    @JsonPropertyDescription("")
    private ConnectionPoolSettings connectionPool;
    /**
     * 
     * 
     */
    @JsonProperty("loadBalancer")
    @JsonPropertyDescription("")
    private LoadBalancerSettings loadBalancer;
    /**
     * 
     * 
     */
    @JsonProperty("outlierDetection")
    @JsonPropertyDescription("")
    private OutlierDetection outlierDetection;
    /**
     * 
     * 
     */
    @JsonProperty("portLevelSettings")
    @JsonPropertyDescription("")
    private List<PortTrafficPolicy> portLevelSettings = new ArrayList<PortTrafficPolicy>();
    /**
     * 
     * 
     */
    @JsonProperty("tls")
    @JsonPropertyDescription("")
    private TLSSettings tls;
    private final static long serialVersionUID = -461926505780219622L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrafficPolicy() {
    }

    /**
     * 
     * @param loadBalancer
     * @param portLevelSettings
     * @param connectionPool
     * @param tls
     * @param outlierDetection
     */
    public TrafficPolicy(ConnectionPoolSettings connectionPool, LoadBalancerSettings loadBalancer, OutlierDetection outlierDetection, List<PortTrafficPolicy> portLevelSettings, TLSSettings tls) {
        super();
        this.connectionPool = connectionPool;
        this.loadBalancer = loadBalancer;
        this.outlierDetection = outlierDetection;
        this.portLevelSettings = portLevelSettings;
        this.tls = tls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectionPool")
    public ConnectionPoolSettings getConnectionPool() {
        return connectionPool;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectionPool")
    public void setConnectionPool(ConnectionPoolSettings connectionPool) {
        this.connectionPool = connectionPool;
    }

    /**
     * 
     * 
     */
    @JsonProperty("loadBalancer")
    public LoadBalancerSettings getLoadBalancer() {
        return loadBalancer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("loadBalancer")
    public void setLoadBalancer(LoadBalancerSettings loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outlierDetection")
    public OutlierDetection getOutlierDetection() {
        return outlierDetection;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outlierDetection")
    public void setOutlierDetection(OutlierDetection outlierDetection) {
        this.outlierDetection = outlierDetection;
    }

    /**
     * 
     * 
     */
    @JsonProperty("portLevelSettings")
    public List<PortTrafficPolicy> getPortLevelSettings() {
        return portLevelSettings;
    }

    /**
     * 
     * 
     */
    @JsonProperty("portLevelSettings")
    public void setPortLevelSettings(List<PortTrafficPolicy> portLevelSettings) {
        this.portLevelSettings = portLevelSettings;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tls")
    public TLSSettings getTls() {
        return tls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tls")
    public void setTls(TLSSettings tls) {
        this.tls = tls;
    }

}
