package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TrafficPolicyBuilder extends TrafficPolicyFluentImpl<TrafficPolicyBuilder> implements VisitableBuilder<TrafficPolicy,TrafficPolicyBuilder>{

    TrafficPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public TrafficPolicyBuilder(){
            this(true);
    }
    public TrafficPolicyBuilder(Boolean validationEnabled){
            this(new TrafficPolicy(), validationEnabled);
    }
    public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TrafficPolicy(), validationEnabled);
    }
    public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent,TrafficPolicy instance){
            this(fluent, instance, true);
    }
    public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent,TrafficPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConnectionPool(instance.getConnectionPool()); 
            fluent.withLoadBalancer(instance.getLoadBalancer()); 
            fluent.withOutlierDetection(instance.getOutlierDetection()); 
            fluent.withPortLevelSettings(instance.getPortLevelSettings()); 
            fluent.withTls(instance.getTls()); 
            this.validationEnabled = validationEnabled; 
    }
    public TrafficPolicyBuilder(TrafficPolicy instance){
            this(instance,true);
    }
    public TrafficPolicyBuilder(TrafficPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConnectionPool(instance.getConnectionPool()); 
            this.withLoadBalancer(instance.getLoadBalancer()); 
            this.withOutlierDetection(instance.getOutlierDetection()); 
            this.withPortLevelSettings(instance.getPortLevelSettings()); 
            this.withTls(instance.getTls()); 
            this.validationEnabled = validationEnabled; 
    }

    public TrafficPolicy build(){
            TrafficPolicy buildable = new TrafficPolicy(fluent.getConnectionPool(),fluent.getLoadBalancer(),fluent.getOutlierDetection(),fluent.getPortLevelSettings(),fluent.getTls());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TrafficPolicyBuilder that = (TrafficPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
