
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.ConsistentHashLB.HashKey;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "useSourceIp"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class UseSourceIpHashKey implements Serializable, HashKey
{

    /**
     * 
     * 
     */
    @JsonProperty("useSourceIp")
    @JsonPropertyDescription("")
    private Boolean useSourceIp;
    private final static long serialVersionUID = 7749044448098918287L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public UseSourceIpHashKey() {
    }

    /**
     * 
     * @param useSourceIp
     */
    public UseSourceIpHashKey(Boolean useSourceIp) {
        super();
        this.useSourceIp = useSourceIp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("useSourceIp")
    public Boolean getUseSourceIp() {
        return useSourceIp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("useSourceIp")
    public void setUseSourceIp(Boolean useSourceIp) {
        this.useSourceIp = useSourceIp;
    }

}
