package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class UseSourceIpHashKeyBuilder extends UseSourceIpHashKeyFluentImpl<UseSourceIpHashKeyBuilder> implements VisitableBuilder<UseSourceIpHashKey,UseSourceIpHashKeyBuilder>{

    UseSourceIpHashKeyFluent<?> fluent;
    Boolean validationEnabled;

    public UseSourceIpHashKeyBuilder(){
            this(true);
    }
    public UseSourceIpHashKeyBuilder(Boolean validationEnabled){
            this(new UseSourceIpHashKey(), validationEnabled);
    }
    public UseSourceIpHashKeyBuilder(UseSourceIpHashKeyFluent<?> fluent){
            this(fluent, true);
    }
    public UseSourceIpHashKeyBuilder(UseSourceIpHashKeyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new UseSourceIpHashKey(), validationEnabled);
    }
    public UseSourceIpHashKeyBuilder(UseSourceIpHashKeyFluent<?> fluent,UseSourceIpHashKey instance){
            this(fluent, instance, true);
    }
    public UseSourceIpHashKeyBuilder(UseSourceIpHashKeyFluent<?> fluent,UseSourceIpHashKey instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUseSourceIp(instance.getUseSourceIp()); 
            this.validationEnabled = validationEnabled; 
    }
    public UseSourceIpHashKeyBuilder(UseSourceIpHashKey instance){
            this(instance,true);
    }
    public UseSourceIpHashKeyBuilder(UseSourceIpHashKey instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUseSourceIp(instance.getUseSourceIp()); 
            this.validationEnabled = validationEnabled; 
    }

    public UseSourceIpHashKey build(){
            UseSourceIpHashKey buildable = new UseSourceIpHashKey(fluent.isUseSourceIp());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            UseSourceIpHashKeyBuilder that = (UseSourceIpHashKeyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
