package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VirtualServiceListBuilder extends VirtualServiceListFluentImpl<VirtualServiceListBuilder> implements VisitableBuilder<VirtualServiceList,VirtualServiceListBuilder>{

    VirtualServiceListFluent<?> fluent;
    Boolean validationEnabled;

    public VirtualServiceListBuilder(){
            this(true);
    }
    public VirtualServiceListBuilder(Boolean validationEnabled){
            this(new VirtualServiceList(), validationEnabled);
    }
    public VirtualServiceListBuilder(VirtualServiceListFluent<?> fluent){
            this(fluent, true);
    }
    public VirtualServiceListBuilder(VirtualServiceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VirtualServiceList(), validationEnabled);
    }
    public VirtualServiceListBuilder(VirtualServiceListFluent<?> fluent,VirtualServiceList instance){
            this(fluent, instance, true);
    }
    public VirtualServiceListBuilder(VirtualServiceListFluent<?> fluent,VirtualServiceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public VirtualServiceListBuilder(VirtualServiceList instance){
            this(instance,true);
    }
    public VirtualServiceListBuilder(VirtualServiceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public VirtualServiceList build(){
            VirtualServiceList buildable = new VirtualServiceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VirtualServiceListBuilder that = (VirtualServiceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
