package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class VirtualServiceListFluentImpl<A extends VirtualServiceListFluent<A>> extends BaseFluent<A> implements VirtualServiceListFluent<A>{

    private String apiVersion;
    private List<VirtualServiceBuilder> items;
    private String kind;
    private ListMeta metadata;

    public VirtualServiceListFluentImpl(){
    }
    public VirtualServiceListFluentImpl(VirtualServiceList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,VirtualService item){
            if (this.items == null) {this.items = new ArrayList<VirtualServiceBuilder>();}
            VirtualServiceBuilder builder = new VirtualServiceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,VirtualService item){
            if (this.items == null) {this.items = new ArrayList<VirtualServiceBuilder>();}
            VirtualServiceBuilder builder = new VirtualServiceBuilder(item);
            if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(VirtualService... items){
            if (this.items == null) {this.items = new ArrayList<VirtualServiceBuilder>();}
            for (VirtualService item : items) {VirtualServiceBuilder builder = new VirtualServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<VirtualService> items){
            if (this.items == null) {this.items = new ArrayList<VirtualServiceBuilder>();}
            for (VirtualService item : items) {VirtualServiceBuilder builder = new VirtualServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(VirtualService... items){
            for (VirtualService item : items) {VirtualServiceBuilder builder = new VirtualServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<VirtualService> items){
            for (VirtualService item : items) {VirtualServiceBuilder builder = new VirtualServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(Predicate<VirtualServiceBuilder> predicate){
            if (items == null) return (A) this;
            final Iterator<VirtualServiceBuilder> each = items.iterator();
            final List visitables = _visitables.get("items");
            while (each.hasNext()) {
              VirtualServiceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<VirtualService> getItems(){
            return build(items);
    }

    public List<VirtualService> buildItems(){
            return build(items);
    }

    public VirtualService buildItem(int index){
            return this.items.get(index).build();
    }

    public VirtualService buildFirstItem(){
            return this.items.get(0).build();
    }

    public VirtualService buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public VirtualService buildMatchingItem(Predicate<VirtualServiceBuilder> predicate){
            for (VirtualServiceBuilder item: items) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(Predicate<VirtualServiceBuilder> predicate){
            for (VirtualServiceBuilder item: items) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withItems(List<VirtualService> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<VirtualServiceBuilder>(); for (VirtualService item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(VirtualService... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (VirtualService item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public VirtualServiceListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public VirtualServiceListFluent.ItemsNested<A> addNewItemLike(VirtualService item){
            return new ItemsNestedImpl(-1, item);
    }

    public VirtualServiceListFluent.ItemsNested<A> setNewItemLike(int index,VirtualService item){
            return new ItemsNestedImpl(index, item);
    }

    public VirtualServiceListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public VirtualServiceListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public VirtualServiceListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public VirtualServiceListFluent.ItemsNested<A> editMatchingItem(Predicate<VirtualServiceBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            VirtualServiceListFluentImpl that = (VirtualServiceListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends VirtualServiceFluentImpl<VirtualServiceListFluent.ItemsNested<N>> implements VirtualServiceListFluent.ItemsNested<N>,Nested<N>{

            private final VirtualServiceBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,VirtualService item){
                    this.index = index;
                    this.builder = new VirtualServiceBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new VirtualServiceBuilder(this);
            }
    
    public N and(){
            return (N) VirtualServiceListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
