
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "exportTo",
    "gateways",
    "hosts",
    "http",
    "tcp",
    "tls"
})
@IstioKind(name = "VirtualService", plural = "virtualservices")
@IstioApiVersion("networking.istio.io/v1alpha3")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class VirtualServiceSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("exportTo")
    @JsonPropertyDescription("")
    private List<String> exportTo = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    @JsonPropertyDescription("")
    private List<String> gateways = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    private List<String> hosts = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("http")
    @JsonPropertyDescription("")
    private List<HTTPRoute> http = new ArrayList<HTTPRoute>();
    /**
     * 
     * 
     */
    @JsonProperty("tcp")
    @JsonPropertyDescription("")
    private List<TCPRoute> tcp = new ArrayList<TCPRoute>();
    /**
     * 
     * 
     */
    @JsonProperty("tls")
    @JsonPropertyDescription("")
    private List<TLSRoute> tls = new ArrayList<TLSRoute>();
    private final static long serialVersionUID = -1289114497819912083L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public VirtualServiceSpec() {
    }

    /**
     * 
     * @param tcp
     * @param gateways
     * @param hosts
     * @param http
     * @param tls
     * @param exportTo
     */
    public VirtualServiceSpec(List<String> exportTo, List<String> gateways, List<String> hosts, List<HTTPRoute> http, List<TCPRoute> tcp, List<TLSRoute> tls) {
        super();
        this.exportTo = exportTo;
        this.gateways = gateways;
        this.hosts = hosts;
        this.http = http;
        this.tcp = tcp;
        this.tls = tls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exportTo")
    public List<String> getExportTo() {
        return exportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exportTo")
    public void setExportTo(List<String> exportTo) {
        this.exportTo = exportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    public List<String> getGateways() {
        return gateways;
    }

    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    public void setGateways(List<String> gateways) {
        this.gateways = gateways;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http")
    public List<HTTPRoute> getHttp() {
        return http;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http")
    public void setHttp(List<HTTPRoute> http) {
        this.http = http;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tcp")
    public List<TCPRoute> getTcp() {
        return tcp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tcp")
    public void setTcp(List<TCPRoute> tcp) {
        this.tcp = tcp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tls")
    public List<TLSRoute> getTls() {
        return tls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tls")
    public void setTls(List<TLSRoute> tls) {
        this.tls = tls;
    }

}
