
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "handler",
    "instances",
    "name"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Action implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("handler")
    @JsonPropertyDescription("")
    private String handler;
    /**
     * 
     * 
     */
    @JsonProperty("instances")
    @JsonPropertyDescription("")
    private List<String> instances = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    private final static long serialVersionUID = -3359161947822601564L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Action() {
    }

    /**
     * 
     * @param handler
     * @param instances
     * @param name
     */
    public Action(String handler, List<String> instances, String name) {
        super();
        this.handler = handler;
        this.instances = instances;
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("handler")
    public String getHandler() {
        return handler;
    }

    /**
     * 
     * 
     */
    @JsonProperty("handler")
    public void setHandler(String handler) {
        this.handler = handler;
    }

    /**
     * 
     * 
     */
    @JsonProperty("instances")
    public List<String> getInstances() {
        return instances;
    }

    /**
     * 
     * 
     */
    @JsonProperty("instances")
    public void setInstances(List<String> instances) {
        this.instances = instances;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

}
