package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ActionFluentImpl<A extends ActionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ActionFluent<A>{

    private String handler;
    private List<String> instances;
    private String name;

    public ActionFluentImpl(){
    }
    public ActionFluentImpl(Action instance){
            this.withHandler(instance.getHandler()); 
            this.withInstances(instance.getInstances()); 
            this.withName(instance.getName()); 
    }

    public String getHandler(){
            return this.handler;
    }

    public A withHandler(String handler){
            this.handler=handler; return (A) this;
    }

    public Boolean hasHandler(){
            return this.handler != null;
    }

    public A withNewHandler(String arg1){
            return (A)withHandler(new String(arg1));
    }

    public A withNewHandler(StringBuilder arg1){
            return (A)withHandler(new String(arg1));
    }

    public A withNewHandler(StringBuffer arg1){
            return (A)withHandler(new String(arg1));
    }

    public A addToInstances(int index,String item){
            if (this.instances == null) {this.instances = new ArrayList<String>();}
            this.instances.add(index, item);
            return (A)this;
    }

    public A setToInstances(int index,String item){
            if (this.instances == null) {this.instances = new ArrayList<String>();}
            this.instances.set(index, item); return (A)this;
    }

    public A addToInstances(String... items){
            if (this.instances == null) {this.instances = new ArrayList<String>();}
            for (String item : items) {this.instances.add(item);} return (A)this;
    }

    public A addAllToInstances(Collection<String> items){
            if (this.instances == null) {this.instances = new ArrayList<String>();}
            for (String item : items) {this.instances.add(item);} return (A)this;
    }

    public A removeFromInstances(String... items){
            for (String item : items) {if (this.instances!= null){ this.instances.remove(item);}} return (A)this;
    }

    public A removeAllFromInstances(Collection<String> items){
            for (String item : items) {if (this.instances!= null){ this.instances.remove(item);}} return (A)this;
    }

    public List<String> getInstances(){
            return this.instances;
    }

    public String getInstance(int index){
            return this.instances.get(index);
    }

    public String getFirstInstance(){
            return this.instances.get(0);
    }

    public String getLastInstance(){
            return this.instances.get(instances.size() - 1);
    }

    public String getMatchingInstance(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: instances) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingInstance(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: instances) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withInstances(List<String> instances){
            if (this.instances != null) { _visitables.get("instances").removeAll(this.instances);}
            if (instances != null) {this.instances = new ArrayList<String>(); for (String item : instances){this.addToInstances(item);}} else { this.instances = null;} return (A) this;
    }

    public A withInstances(String... instances){
            if (this.instances != null) {this.instances.clear();}
            if (instances != null) {for (String item :instances){ this.addToInstances(item);}} return (A) this;
    }

    public Boolean hasInstances(){
            return instances != null && !instances.isEmpty();
    }

    public A addNewInstance(String arg1){
            return (A)addToInstances(new String(arg1));
    }

    public A addNewInstance(StringBuilder arg1){
            return (A)addToInstances(new String(arg1));
    }

    public A addNewInstance(StringBuffer arg1){
            return (A)addToInstances(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ActionFluentImpl that = (ActionFluentImpl) o;
            if (handler != null ? !handler.equals(that.handler) :that.handler != null) return false;
            if (instances != null ? !instances.equals(that.instances) :that.instances != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }




}
