
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "denominator",
    "numerator"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class FractionalPercent implements Serializable
{

    @JsonProperty("denominator")
    private DenominatorType denominator;
    /**
     * 
     * 
     */
    @JsonProperty("numerator")
    @JsonPropertyDescription("")
    private Integer numerator;
    private final static long serialVersionUID = 2997148806267166081L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FractionalPercent() {
    }

    /**
     * 
     * @param denominator
     * @param numerator
     */
    public FractionalPercent(DenominatorType denominator, Integer numerator) {
        super();
        this.denominator = denominator;
        this.numerator = numerator;
    }

    @JsonProperty("denominator")
    public DenominatorType getDenominator() {
        return denominator;
    }

    @JsonProperty("denominator")
    public void setDenominator(DenominatorType denominator) {
        this.denominator = denominator;
    }

    /**
     * 
     * 
     */
    @JsonProperty("numerator")
    public Integer getNumerator() {
        return numerator;
    }

    /**
     * 
     * 
     */
    @JsonProperty("numerator")
    public void setNumerator(Integer numerator) {
        this.numerator = numerator;
    }

}
