package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FractionalPercentBuilder extends FractionalPercentFluentImpl<FractionalPercentBuilder> implements VisitableBuilder<FractionalPercent,FractionalPercentBuilder>{

    FractionalPercentFluent<?> fluent;
    Boolean validationEnabled;

    public FractionalPercentBuilder(){
            this(true);
    }
    public FractionalPercentBuilder(Boolean validationEnabled){
            this(new FractionalPercent(), validationEnabled);
    }
    public FractionalPercentBuilder(FractionalPercentFluent<?> fluent){
            this(fluent, true);
    }
    public FractionalPercentBuilder(FractionalPercentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new FractionalPercent(), validationEnabled);
    }
    public FractionalPercentBuilder(FractionalPercentFluent<?> fluent,FractionalPercent instance){
            this(fluent, instance, true);
    }
    public FractionalPercentBuilder(FractionalPercentFluent<?> fluent,FractionalPercent instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDenominator(instance.getDenominator()); 
            fluent.withNumerator(instance.getNumerator()); 
            this.validationEnabled = validationEnabled; 
    }
    public FractionalPercentBuilder(FractionalPercent instance){
            this(instance,true);
    }
    public FractionalPercentBuilder(FractionalPercent instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDenominator(instance.getDenominator()); 
            this.withNumerator(instance.getNumerator()); 
            this.validationEnabled = validationEnabled; 
    }

    public FractionalPercent build(){
            FractionalPercent buildable = new FractionalPercent(fluent.getDenominator(),fluent.getNumerator());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FractionalPercentBuilder that = (FractionalPercentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
