package me.snowdrop.istio.api.policy.v1beta1;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class FractionalPercentFluentImpl<A extends FractionalPercentFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FractionalPercentFluent<A>{

    private DenominatorType denominator;
    private Integer numerator;

    public FractionalPercentFluentImpl(){
    }
    public FractionalPercentFluentImpl(FractionalPercent instance){
            this.withDenominator(instance.getDenominator()); 
            this.withNumerator(instance.getNumerator()); 
    }

    public DenominatorType getDenominator(){
            return this.denominator;
    }

    public A withDenominator(DenominatorType denominator){
            this.denominator=denominator; return (A) this;
    }

    public Boolean hasDenominator(){
            return this.denominator != null;
    }

    public Integer getNumerator(){
            return this.numerator;
    }

    public A withNumerator(Integer numerator){
            this.numerator=numerator; return (A) this;
    }

    public Boolean hasNumerator(){
            return this.numerator != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            FractionalPercentFluentImpl that = (FractionalPercentFluentImpl) o;
            if (denominator != null ? !denominator.equals(that.denominator) :that.denominator != null) return false;
            if (numerator != null ? !numerator.equals(that.numerator) :that.numerator != null) return false;
            return true;
    }




}
