
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "operation",
    "values"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HeaderOperationTemplate implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    @JsonProperty("operation")
    private Operation operation;
    /**
     * 
     * 
     */
    @JsonProperty("values")
    @JsonPropertyDescription("")
    private List<String> values = new ArrayList<String>();
    private final static long serialVersionUID = -972314756569876306L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HeaderOperationTemplate() {
    }

    /**
     * 
     * @param values
     * @param name
     * @param operation
     */
    public HeaderOperationTemplate(String name, Operation operation, List<String> values) {
        super();
        this.name = name;
        this.operation = operation;
        this.values = values;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("operation")
    public Operation getOperation() {
        return operation;
    }

    @JsonProperty("operation")
    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    /**
     * 
     * 
     */
    @JsonProperty("values")
    public List<String> getValues() {
        return values;
    }

    /**
     * 
     * 
     */
    @JsonProperty("values")
    public void setValues(List<String> values) {
        this.values = values;
    }

}
