package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HeaderOperationTemplateBuilder extends HeaderOperationTemplateFluentImpl<HeaderOperationTemplateBuilder> implements VisitableBuilder<HeaderOperationTemplate,HeaderOperationTemplateBuilder>{

    HeaderOperationTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public HeaderOperationTemplateBuilder(){
            this(true);
    }
    public HeaderOperationTemplateBuilder(Boolean validationEnabled){
            this(new HeaderOperationTemplate(), validationEnabled);
    }
    public HeaderOperationTemplateBuilder(HeaderOperationTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public HeaderOperationTemplateBuilder(HeaderOperationTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HeaderOperationTemplate(), validationEnabled);
    }
    public HeaderOperationTemplateBuilder(HeaderOperationTemplateFluent<?> fluent,HeaderOperationTemplate instance){
            this(fluent, instance, true);
    }
    public HeaderOperationTemplateBuilder(HeaderOperationTemplateFluent<?> fluent,HeaderOperationTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withOperation(instance.getOperation()); 
            fluent.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }
    public HeaderOperationTemplateBuilder(HeaderOperationTemplate instance){
            this(instance,true);
    }
    public HeaderOperationTemplateBuilder(HeaderOperationTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withOperation(instance.getOperation()); 
            this.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }

    public HeaderOperationTemplate build(){
            HeaderOperationTemplate buildable = new HeaderOperationTemplate(fluent.getName(),fluent.getOperation(),fluent.getValues());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HeaderOperationTemplateBuilder that = (HeaderOperationTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
