package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class HeaderOperationTemplateFluentImpl<A extends HeaderOperationTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HeaderOperationTemplateFluent<A>{

    private String name;
    private me.snowdrop.istio.api.policy.v1beta1.Operation operation;
    private List<String> values;

    public HeaderOperationTemplateFluentImpl(){
    }
    public HeaderOperationTemplateFluentImpl(HeaderOperationTemplate instance){
            this.withName(instance.getName()); 
            this.withOperation(instance.getOperation()); 
            this.withValues(instance.getValues()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public me.snowdrop.istio.api.policy.v1beta1.Operation getOperation(){
            return this.operation;
    }

    public A withOperation(me.snowdrop.istio.api.policy.v1beta1.Operation operation){
            this.operation=operation; return (A) this;
    }

    public Boolean hasOperation(){
            return this.operation != null;
    }

    public A addToValues(int index,String item){
            if (this.values == null) {this.values = new ArrayList<String>();}
            this.values.add(index, item);
            return (A)this;
    }

    public A setToValues(int index,String item){
            if (this.values == null) {this.values = new ArrayList<String>();}
            this.values.set(index, item); return (A)this;
    }

    public A addToValues(String... items){
            if (this.values == null) {this.values = new ArrayList<String>();}
            for (String item : items) {this.values.add(item);} return (A)this;
    }

    public A addAllToValues(Collection<String> items){
            if (this.values == null) {this.values = new ArrayList<String>();}
            for (String item : items) {this.values.add(item);} return (A)this;
    }

    public A removeFromValues(String... items){
            for (String item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
    }

    public A removeAllFromValues(Collection<String> items){
            for (String item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
    }

    public List<String> getValues(){
            return this.values;
    }

    public String getValue(int index){
            return this.values.get(index);
    }

    public String getFirstValue(){
            return this.values.get(0);
    }

    public String getLastValue(){
            return this.values.get(values.size() - 1);
    }

    public String getMatchingValue(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: values) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingValue(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: values) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withValues(List<String> values){
            if (this.values != null) { _visitables.get("values").removeAll(this.values);}
            if (values != null) {this.values = new ArrayList<String>(); for (String item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
    }

    public A withValues(String... values){
            if (this.values != null) {this.values.clear();}
            if (values != null) {for (String item :values){ this.addToValues(item);}} return (A) this;
    }

    public Boolean hasValues(){
            return values != null && !values.isEmpty();
    }

    public A addNewValue(String arg1){
            return (A)addToValues(new String(arg1));
    }

    public A addNewValue(StringBuilder arg1){
            return (A)addToValues(new String(arg1));
    }

    public A addNewValue(StringBuffer arg1){
            return (A)addToValues(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HeaderOperationTemplateFluentImpl that = (HeaderOperationTemplateFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (operation != null ? !operation.equals(that.operation) :that.operation != null) return false;
            if (values != null ? !values.equals(that.values) :that.values != null) return false;
            return true;
    }




}
