
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attributeExpression",
    "percentSampled",
    "useIndependentRandomness"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RandomSampling implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("attributeExpression")
    @JsonPropertyDescription("")
    private String attributeExpression;
    /**
     * 
     * 
     */
    @JsonProperty("percentSampled")
    @JsonPropertyDescription("")
    private FractionalPercent percentSampled;
    /**
     * 
     * 
     */
    @JsonProperty("useIndependentRandomness")
    @JsonPropertyDescription("")
    private Boolean useIndependentRandomness;
    private final static long serialVersionUID = 8522360719510693150L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RandomSampling() {
    }

    /**
     * 
     * @param attributeExpression
     * @param percentSampled
     * @param useIndependentRandomness
     */
    public RandomSampling(String attributeExpression, FractionalPercent percentSampled, Boolean useIndependentRandomness) {
        super();
        this.attributeExpression = attributeExpression;
        this.percentSampled = percentSampled;
        this.useIndependentRandomness = useIndependentRandomness;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attributeExpression")
    public String getAttributeExpression() {
        return attributeExpression;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attributeExpression")
    public void setAttributeExpression(String attributeExpression) {
        this.attributeExpression = attributeExpression;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percentSampled")
    public FractionalPercent getPercentSampled() {
        return percentSampled;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percentSampled")
    public void setPercentSampled(FractionalPercent percentSampled) {
        this.percentSampled = percentSampled;
    }

    /**
     * 
     * 
     */
    @JsonProperty("useIndependentRandomness")
    public Boolean getUseIndependentRandomness() {
        return useIndependentRandomness;
    }

    /**
     * 
     * 
     */
    @JsonProperty("useIndependentRandomness")
    public void setUseIndependentRandomness(Boolean useIndependentRandomness) {
        this.useIndependentRandomness = useIndependentRandomness;
    }

}
