package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RandomSamplingBuilder extends RandomSamplingFluentImpl<RandomSamplingBuilder> implements VisitableBuilder<RandomSampling,RandomSamplingBuilder>{

    RandomSamplingFluent<?> fluent;
    Boolean validationEnabled;

    public RandomSamplingBuilder(){
            this(true);
    }
    public RandomSamplingBuilder(Boolean validationEnabled){
            this(new RandomSampling(), validationEnabled);
    }
    public RandomSamplingBuilder(RandomSamplingFluent<?> fluent){
            this(fluent, true);
    }
    public RandomSamplingBuilder(RandomSamplingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RandomSampling(), validationEnabled);
    }
    public RandomSamplingBuilder(RandomSamplingFluent<?> fluent,RandomSampling instance){
            this(fluent, instance, true);
    }
    public RandomSamplingBuilder(RandomSamplingFluent<?> fluent,RandomSampling instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttributeExpression(instance.getAttributeExpression()); 
            fluent.withPercentSampled(instance.getPercentSampled()); 
            fluent.withUseIndependentRandomness(instance.getUseIndependentRandomness()); 
            this.validationEnabled = validationEnabled; 
    }
    public RandomSamplingBuilder(RandomSampling instance){
            this(instance,true);
    }
    public RandomSamplingBuilder(RandomSampling instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttributeExpression(instance.getAttributeExpression()); 
            this.withPercentSampled(instance.getPercentSampled()); 
            this.withUseIndependentRandomness(instance.getUseIndependentRandomness()); 
            this.validationEnabled = validationEnabled; 
    }

    public RandomSampling build(){
            RandomSampling buildable = new RandomSampling(fluent.getAttributeExpression(),fluent.getPercentSampled(),fluent.isUseIndependentRandomness());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RandomSamplingBuilder that = (RandomSamplingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
