
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "maxUnsampledEntries",
    "samplingDuration",
    "samplingRate"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RateLimitSampling implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("maxUnsampledEntries")
    @JsonPropertyDescription("")
    private Integer maxUnsampledEntries;
    /**
     * 
     * 
     */
    @JsonProperty("samplingDuration")
    @JsonPropertyDescription("")
    private Integer samplingDuration;
    /**
     * 
     * 
     */
    @JsonProperty("samplingRate")
    @JsonPropertyDescription("")
    private Integer samplingRate;
    private final static long serialVersionUID = 8815249366141347011L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RateLimitSampling() {
    }

    /**
     * 
     * @param samplingRate
     * @param samplingDuration
     * @param maxUnsampledEntries
     */
    public RateLimitSampling(Integer maxUnsampledEntries, Integer samplingDuration, Integer samplingRate) {
        super();
        this.maxUnsampledEntries = maxUnsampledEntries;
        this.samplingDuration = samplingDuration;
        this.samplingRate = samplingRate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxUnsampledEntries")
    public Integer getMaxUnsampledEntries() {
        return maxUnsampledEntries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxUnsampledEntries")
    public void setMaxUnsampledEntries(Integer maxUnsampledEntries) {
        this.maxUnsampledEntries = maxUnsampledEntries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("samplingDuration")
    public Integer getSamplingDuration() {
        return samplingDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("samplingDuration")
    public void setSamplingDuration(Integer samplingDuration) {
        this.samplingDuration = samplingDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("samplingRate")
    public Integer getSamplingRate() {
        return samplingRate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("samplingRate")
    public void setSamplingRate(Integer samplingRate) {
        this.samplingRate = samplingRate;
    }

}
