package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RateLimitSamplingBuilder extends RateLimitSamplingFluentImpl<RateLimitSamplingBuilder> implements VisitableBuilder<RateLimitSampling,RateLimitSamplingBuilder>{

    RateLimitSamplingFluent<?> fluent;
    Boolean validationEnabled;

    public RateLimitSamplingBuilder(){
            this(true);
    }
    public RateLimitSamplingBuilder(Boolean validationEnabled){
            this(new RateLimitSampling(), validationEnabled);
    }
    public RateLimitSamplingBuilder(RateLimitSamplingFluent<?> fluent){
            this(fluent, true);
    }
    public RateLimitSamplingBuilder(RateLimitSamplingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RateLimitSampling(), validationEnabled);
    }
    public RateLimitSamplingBuilder(RateLimitSamplingFluent<?> fluent,RateLimitSampling instance){
            this(fluent, instance, true);
    }
    public RateLimitSamplingBuilder(RateLimitSamplingFluent<?> fluent,RateLimitSampling instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxUnsampledEntries(instance.getMaxUnsampledEntries()); 
            fluent.withSamplingDuration(instance.getSamplingDuration()); 
            fluent.withSamplingRate(instance.getSamplingRate()); 
            this.validationEnabled = validationEnabled; 
    }
    public RateLimitSamplingBuilder(RateLimitSampling instance){
            this(instance,true);
    }
    public RateLimitSamplingBuilder(RateLimitSampling instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxUnsampledEntries(instance.getMaxUnsampledEntries()); 
            this.withSamplingDuration(instance.getSamplingDuration()); 
            this.withSamplingRate(instance.getSamplingRate()); 
            this.validationEnabled = validationEnabled; 
    }

    public RateLimitSampling build(){
            RateLimitSampling buildable = new RateLimitSampling(fluent.getMaxUnsampledEntries(),fluent.getSamplingDuration(),fluent.getSamplingRate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RateLimitSamplingBuilder that = (RateLimitSamplingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
