package me.snowdrop.istio.api.policy.v1beta1;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class RateLimitSamplingFluentImpl<A extends RateLimitSamplingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RateLimitSamplingFluent<A>{

    private Integer maxUnsampledEntries;
    private Integer samplingDuration;
    private Integer samplingRate;

    public RateLimitSamplingFluentImpl(){
    }
    public RateLimitSamplingFluentImpl(RateLimitSampling instance){
            this.withMaxUnsampledEntries(instance.getMaxUnsampledEntries()); 
            this.withSamplingDuration(instance.getSamplingDuration()); 
            this.withSamplingRate(instance.getSamplingRate()); 
    }

    public Integer getMaxUnsampledEntries(){
            return this.maxUnsampledEntries;
    }

    public A withMaxUnsampledEntries(Integer maxUnsampledEntries){
            this.maxUnsampledEntries=maxUnsampledEntries; return (A) this;
    }

    public Boolean hasMaxUnsampledEntries(){
            return this.maxUnsampledEntries != null;
    }

    public Integer getSamplingDuration(){
            return this.samplingDuration;
    }

    public A withSamplingDuration(Integer samplingDuration){
            this.samplingDuration=samplingDuration; return (A) this;
    }

    public Boolean hasSamplingDuration(){
            return this.samplingDuration != null;
    }

    public Integer getSamplingRate(){
            return this.samplingRate;
    }

    public A withSamplingRate(Integer samplingRate){
            this.samplingRate=samplingRate; return (A) this;
    }

    public Boolean hasSamplingRate(){
            return this.samplingRate != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RateLimitSamplingFluentImpl that = (RateLimitSamplingFluentImpl) o;
            if (maxUnsampledEntries != null ? !maxUnsampledEntries.equals(that.maxUnsampledEntries) :that.maxUnsampledEntries != null) return false;
            if (samplingDuration != null ? !samplingDuration.equals(that.samplingDuration) :that.samplingDuration != null) return false;
            if (samplingRate != null ? !samplingRate.equals(that.samplingRate) :that.samplingRate != null) return false;
            return true;
    }




}
